/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.models;

import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.furniture.block.AbstractChair;
import org.betterx.bclib.furniture.block.BaseChair;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.jetbrains.annotations.NotNull;

public class BCLModels {
    public static final TextureSlot CLOTH = TextureSlot.create((String)"cloth");
    public static final TextureSlot TEXTURE1 = TextureSlot.create((String)"texture1");
    public static final TextureSlot GLOW = TextureSlot.create((String)"glow");
    public static final TextureSlot METAL = TextureSlot.create((String)"metal");
    public static final TextureSlot GLASS = TextureSlot.create((String)"glass");
    public static final TextureSlot PANEL = TextureSlot.create((String)"panel");
    public static final ResourceLocation BAR_STOOL_MODEL_LOCATION = BCLib.C.mk("block/bar_stool");
    public static final ModelTemplate BAR_STOOL = new ModelTemplate(Optional.of(BAR_STOOL_MODEL_LOCATION), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE, CLOTH});
    public static final ResourceLocation CHAIR_MODEL_LOCATION = BCLib.C.mk("block/chair");
    public static final ModelTemplate CHAIR = new ModelTemplate(Optional.of(CHAIR_MODEL_LOCATION), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
    public static final ModelTemplate CHAIR_TOP = new ModelTemplate(Optional.empty(), Optional.of("_top"), new TextureSlot[]{TextureSlot.PARTICLE});
    public static final ResourceLocation TABURET_MODEL_LOCATION = BCLib.C.mk("block/taburet");
    public static final ModelTemplate TABURET = new ModelTemplate(Optional.of(TABURET_MODEL_LOCATION), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
    public static final ResourceLocation CHEST_MODEL_LOCATION = BCLib.C.mk("block/chest_item");
    public static final ModelTemplate CHEST_ITEM = new ModelTemplate(Optional.of(CHEST_MODEL_LOCATION), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
    public static final ResourceLocation PATH_MODEL_LOCATION = BCLib.C.mk("block/path");
    public static final ModelTemplate PATH = new ModelTemplate(Optional.of(PATH_MODEL_LOCATION), Optional.empty(), new TextureSlot[]{TextureSlot.TOP, TextureSlot.BOTTOM, TextureSlot.SIDE});
    public static final ResourceLocation LADDER_MODEL_LOCATION = BCLib.C.mk("block/ladder");
    public static final ModelTemplate LADDER = new ModelTemplate(Optional.of(LADDER_MODEL_LOCATION), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE});
    public static final ModelTemplate BULB_LANTERN_FLOOR = new ModelTemplate(Optional.of(BCLib.C.mk("block/bulb_lantern_floor")), Optional.empty(), new TextureSlot[]{GLOW, METAL});
    public static final ModelTemplate BULB_LANTERN_CEIL = new ModelTemplate(Optional.of(BCLib.C.mk("block/bulb_lantern_ceil")), Optional.empty(), new TextureSlot[]{GLOW, METAL});
    public static final ModelTemplate STONE_LANTERN_FLOOR = new ModelTemplate(Optional.of(BCLib.C.mk("block/stone_lantern_floor")), Optional.empty(), new TextureSlot[]{TextureSlot.TOP, TextureSlot.BOTTOM, TextureSlot.SIDE, GLASS});
    public static final ModelTemplate STONE_LANTERN_CEIL = new ModelTemplate(Optional.of(BCLib.C.mk("block/stone_lantern_ceil")), Optional.empty(), new TextureSlot[]{TextureSlot.TOP, TextureSlot.BOTTOM, TextureSlot.SIDE, GLASS});
    public static final ModelTemplate CROSS_SHADED = new ModelTemplate(Optional.of(BCLib.C.mk("block/cross_shaded")), Optional.empty(), new TextureSlot[]{TextureSlot.CROSS});
    public static final ModelTemplate ANVIL = new ModelTemplate(Optional.of(BCLib.C.mk("block/anvil")), Optional.empty(), new TextureSlot[]{TextureSlot.FRONT, TextureSlot.BACK, TextureSlot.TOP, TextureSlot.BOTTOM, PANEL});
    public static final ModelTemplate TRAPDOOR = new ModelTemplate(Optional.of(BCLib.C.mk("block/sided_trapdoor")), Optional.empty(), new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.SIDE});
    public static final ModelTemplate FURNACE_GLOW = new ModelTemplate(Optional.of(BCLib.C.mk("block/furnace_glow")), Optional.empty(), new TextureSlot[]{TextureSlot.TOP, TextureSlot.SIDE, TextureSlot.FRONT, GLOW});

    public static void createBarStoolBlockModel(WoverBlockModelGenerators generators, Block block, Block woodType, Block clothType) {
        TextureMapping mapping = WoverBlockModelGenerators.textureMappingOf((TextureSlot)TextureSlot.TEXTURE, (ResourceLocation)TextureMapping.getBlockTexture((Block)woodType), (TextureSlot)CLOTH, (ResourceLocation)TextureMapping.getBlockTexture((Block)clothType));
        ResourceLocation modelLocation = BAR_STOOL.create(block, mapping, generators.vanillaGenerator.modelOutput());
        MultiVariantGenerator blockStateGenerator = MultiVariantGenerator.multiVariant((Block)block).with(BCLModels.getChairFacingPropertyDispatch(modelLocation));
        generators.acceptBlockState((BlockStateGenerator)blockStateGenerator);
    }

    public static void createTaburetBlockModel(WoverBlockModelGenerators generators, Block block, Block woodType) {
        TextureMapping mapping = WoverBlockModelGenerators.textureMappingOf((TextureSlot)TextureSlot.TEXTURE, (ResourceLocation)TextureMapping.getBlockTexture((Block)woodType));
        ResourceLocation modelLocation = TABURET.create(block, mapping, generators.vanillaGenerator.modelOutput());
        MultiVariantGenerator blockStateGenerator = MultiVariantGenerator.multiVariant((Block)block).with(BCLModels.getChairFacingPropertyDispatch(modelLocation));
        generators.acceptBlockState((BlockStateGenerator)blockStateGenerator);
    }

    public static void createChairBlockModel(WoverBlockModelGenerators generators, Block block, Block woodType, Block cloth) {
        TextureMapping mapping = WoverBlockModelGenerators.textureMappingOf((TextureSlot)TextureSlot.TEXTURE, (ResourceLocation)TextureMapping.getBlockTexture((Block)woodType), (TextureSlot)TextureSlot.PARTICLE, (ResourceLocation)TextureMapping.getBlockTexture((Block)woodType));
        ResourceLocation modelLocation = CHAIR.create(block, mapping, generators.vanillaGenerator.modelOutput());
        ResourceLocation topLocation = generators.particleOnlyModel(woodType);
        MultiVariantGenerator blockStateGenerator = MultiVariantGenerator.multiVariant((Block)block).with((PropertyDispatch)PropertyDispatch.properties((Property)AbstractChair.FACING, (Property)BaseChair.TOP).select((Comparable)Direction.EAST, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation)).select((Comparable)Direction.NORTH, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)topLocation)).select((Comparable)Direction.EAST, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)topLocation)).select((Comparable)Direction.SOUTH, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)topLocation)).select((Comparable)Direction.WEST, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)topLocation)));
        generators.acceptBlockState((BlockStateGenerator)blockStateGenerator);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PropertyDispatch.C1<Direction> getChairFacingPropertyDispatch(ResourceLocation modelLocation) {
        return PropertyDispatch.property((Property)AbstractChair.FACING).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180));
    }
}

