/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.ItemModelProvider;
import org.betterx.bclib.interfaces.RuntimeBlockModelProvider;
import org.betterx.bclib.models.RecordItemModelProvider;

public class CustomModelBakery {
    private final Map<ResourceLocation, UnbakedModel> models = Maps.newConcurrentMap();
    private final Map<Block, List<StateModelPair>> blockModels = Maps.newConcurrentMap();

    public UnbakedModel getBlockModel(ResourceLocation location) {
        return this.models.get(location);
    }

    public UnbakedModel getItemModel(ResourceLocation location) {
        return this.models.get(location);
    }

    public void loadCustomModels(ResourceManager resourceManager) {
        BuiltInRegistries.BLOCK.stream().filter(block -> block instanceof RuntimeBlockModelProvider).forEach(block -> {
            ResourceLocation blockID = BuiltInRegistries.BLOCK.getKey(block);
            if (blockID == null) {
                BCLib.LOGGER.warn("Skip runtime block model: missing registry key for {}", new Object[]{block});
                return;
            }
            try {
                ResourceLocation storageID = ResourceLocation.fromNamespaceAndPath((String)blockID.getNamespace(), (String)("blockstates/" + blockID.getPath() + ".json"));
                if (resourceManager.getResource(storageID).isEmpty()) {
                    this.addBlockModel(blockID, (Block)block);
                }
                if (resourceManager.getResource(storageID = ResourceLocation.fromNamespaceAndPath((String)blockID.getNamespace(), (String)("models/item/" + blockID.getPath() + ".json"))).isEmpty()) {
                    this.addItemModel(blockID, (ItemModelProvider)block);
                }
            }
            catch (RuntimeException ex) {
                BCLib.LOGGER.error("Failed to build runtime block model for {}", (Object)blockID, (Exception)ex);
            }
        });
        BuiltInRegistries.ITEM.stream().filter(item -> item instanceof ItemModelProvider || RecordItemModelProvider.has(item)).forEach(item -> {
            ResourceLocation registryID = BuiltInRegistries.ITEM.getKey(item);
            if (registryID == null) {
                BCLib.LOGGER.warn("Skip runtime item model: missing registry key for {}", new Object[]{item});
                return;
            }
            try {
                ItemModelProvider provider;
                ResourceLocation storageID = ResourceLocation.fromNamespaceAndPath((String)registryID.getNamespace(), (String)("models/item/" + registryID.getPath() + ".json"));
                ItemModelProvider itemModelProvider = provider = item instanceof ItemModelProvider ? (ItemModelProvider)item : RecordItemModelProvider.get(item);
                if (provider == null) {
                    BCLib.LOGGER.warn("Skip runtime item model: missing provider for {}", new Object[]{registryID});
                    return;
                }
                if (resourceManager.getResource(storageID).isEmpty()) {
                    this.addItemModel(registryID, provider);
                }
            }
            catch (RuntimeException ex) {
                BCLib.LOGGER.error("Failed to build runtime item model for {}", (Object)registryID, (Exception)ex);
            }
        });
    }

    private void addBlockModel(ResourceLocation blockID, Block block) {
        RuntimeBlockModelProvider provider = (RuntimeBlockModelProvider)block;
        ImmutableList states = block.getStateDefinition().getPossibleStates();
        BlockState defaultState = block.defaultBlockState();
        ModelResourceLocation defaultStateID = BlockModelShaper.stateToModelLocation((ResourceLocation)blockID, (BlockState)defaultState);
        UnbakedModel defaultModel = provider.getModelVariant(defaultStateID, defaultState, this.models);
        if (defaultModel == null) {
            BCLib.LOGGER.warn("Skip runtime block model: missing default model for {}", new Object[]{blockID});
            return;
        }
        ArrayList stateModels = new ArrayList(states.size());
        if (defaultModel instanceof MultiPart) {
            states.forEach(blockState -> {
                ModelResourceLocation stateID = BlockModelShaper.stateToModelLocation((ResourceLocation)blockID, (BlockState)blockState);
                this.models.put(stateID.id(), defaultModel);
                stateModels.add(new StateModelPair((BlockState)blockState, defaultModel));
            });
        } else {
            states.forEach(blockState -> {
                UnbakedModel model;
                ModelResourceLocation stateID = BlockModelShaper.stateToModelLocation((ResourceLocation)blockID, (BlockState)blockState);
                UnbakedModel unbakedModel = model = stateID.equals((Object)defaultStateID) ? defaultModel : provider.getModelVariant(stateID, (BlockState)blockState, this.models);
                if (model == null) {
                    BCLib.LOGGER.warn("Skip runtime block model: missing model for {}", new Object[]{stateID});
                    model = defaultModel;
                }
                this.models.put(stateID.id(), model);
                stateModels.add(new StateModelPair((BlockState)blockState, model));
            });
        }
        this.blockModels.put(block, stateModels);
    }

    private void addItemModel(ResourceLocation itemID, ItemModelProvider provider) {
        ModelResourceLocation modelLocation = new ModelResourceLocation(itemID, "inventory");
        ResourceLocation modelKey = modelLocation.id();
        if (!this.models.containsKey(modelKey)) {
            ResourceLocation itemModelLocation = itemID.withPrefix("item/");
            BlockModel model = provider.getItemModel(modelKey);
            if (model == null) {
                BCLib.LOGGER.warn("Skip runtime item model: missing model for {}", new Object[]{itemID});
                return;
            }
            this.models.put(modelKey, (UnbakedModel)model);
            this.models.put(itemModelLocation, (UnbakedModel)model);
        }
    }

    private record StateModelPair(BlockState state, UnbakedModel model) {
    }
}

