/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.models;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.betterx.bclib.client.models.BasePatterns;

public class PatternsHelper {
    private static final Map<ResourceLocation, String> JSON_CACHE = Maps.newConcurrentMap();

    public static Optional<String> createItemGenerated(ResourceLocation itemId) {
        return PatternsHelper.createJson(BasePatterns.ITEM_GENERATED, itemId);
    }

    public static Optional<String> createItemHandheld(ResourceLocation itemId) {
        return PatternsHelper.createJson(BasePatterns.ITEM_HANDHELD, itemId);
    }

    public static Optional<String> createBlockSimple(ResourceLocation blockId) {
        return PatternsHelper.createJson(BasePatterns.BLOCK_BASE, blockId);
    }

    public static Optional<String> createBlockEmpty(ResourceLocation blockId) {
        return PatternsHelper.createJson(BasePatterns.BLOCK_EMPTY, blockId);
    }

    public static Optional<String> createBlockPillar(ResourceLocation blockId) {
        return PatternsHelper.createJson(BasePatterns.BLOCK_PILLAR, blockId);
    }

    public static Optional<String> createBlockBottomTop(ResourceLocation blockId) {
        return PatternsHelper.createJson(BasePatterns.BLOCK_BOTTOM_TOP, blockId);
    }

    public static Optional<String> createBlockColored(ResourceLocation blockId) {
        return PatternsHelper.createJson(BasePatterns.BLOCK_COLORED, blockId);
    }

    public static Optional<JsonObject> getJsonObject(ResourceLocation patternId, ResourceLocation blockId) {
        Optional<String> json = PatternsHelper.createJson(patternId, blockId);
        return json.map(s -> (JsonObject)new Gson().fromJson(s, JsonObject.class));
    }

    public static Optional<String> createJson(ResourceLocation patternId, ResourceLocation blockId) {
        HashMap textures = Maps.newHashMap();
        textures.put("%modid%", blockId.getNamespace());
        textures.put("%texture%", blockId.getPath());
        return PatternsHelper.createJson(patternId, textures);
    }

    public static Optional<String> createJson(ResourceLocation patternId, Map<String, String> textures) {
        Optional<String> optional;
        block11: {
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            Optional patternRes = resourceManager.getResource(patternId);
            if (patternRes.isEmpty()) {
                return Optional.empty();
            }
            InputStream input = ((Resource)patternRes.get()).open();
            try {
                String json = JSON_CACHE.get(patternId);
                if (json == null) {
                    json = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.joining());
                    JSON_CACHE.put(patternId, json);
                }
                for (Map.Entry<String, String> texture : textures.entrySet()) {
                    json = json.replace(texture.getKey(), texture.getValue());
                }
                optional = Optional.of(json);
                if (input == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    return Optional.empty();
                }
            }
            input.close();
        }
        return optional;
    }
}

