/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class HumanoidArmorRenderer {
    public void render(PoseStack pose, MultiBufferSource buffer, ItemStack stack, LivingEntity entity, EquipmentSlot slot, int light, HumanoidModel<LivingEntity> parentModel) {
        HumanoidModel<LivingEntity> model = this.getModelForSlot(entity, slot);
        if (model != null) {
            Item item = stack.getItem();
            if (!(item instanceof ArmorItem)) {
                return;
            }
            ArmorItem armorItem = (ArmorItem)item;
            if (armorItem.getEquipmentSlot() != slot) {
                return;
            }
            parentModel.copyPropertiesTo(model);
            if (model instanceof CopyExtraState) {
                CopyExtraState mdl = (CopyExtraState)model;
                mdl.copyPropertiesFrom(parentModel);
            }
            this.setPartVisibility(model, slot);
            this.renderModel(pose, buffer, light, model, this.getTextureForSlot(slot, this.usesInnerModel(slot)), -1);
            if (stack.hasFoil()) {
                this.renderGlint(pose, buffer, light, model);
            }
        }
    }

    @NotNull
    protected abstract ResourceLocation getTextureForSlot(EquipmentSlot var1, boolean var2);

    protected abstract HumanoidModel<LivingEntity> getModelForSlot(LivingEntity var1, EquipmentSlot var2);

    protected boolean usesInnerModel(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.LEGS;
    }

    protected void renderModel(PoseStack pose, MultiBufferSource buffer, int light, HumanoidModel<LivingEntity> humanoidModel, ResourceLocation texture, int color) {
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)texture));
        humanoidModel.renderToBuffer(pose, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
    }

    protected void renderGlint(PoseStack pose, MultiBufferSource buffer, int light, HumanoidModel<LivingEntity> humanoidModel) {
        humanoidModel.renderToBuffer(pose, buffer.getBuffer(RenderType.armorEntityGlint()), light, OverlayTexture.NO_OVERLAY);
    }

    protected void setPartVisibility(HumanoidModel<LivingEntity> humanoidModel, EquipmentSlot equipmentSlot) {
        humanoidModel.setAllVisible(false);
        switch (equipmentSlot) {
            case HEAD: {
                humanoidModel.head.visible = true;
                humanoidModel.hat.visible = true;
                break;
            }
            case CHEST: {
                humanoidModel.body.visible = true;
                humanoidModel.rightArm.visible = true;
                humanoidModel.leftArm.visible = true;
                break;
            }
            case LEGS: {
                humanoidModel.body.visible = true;
                humanoidModel.rightLeg.visible = true;
                humanoidModel.leftLeg.visible = true;
                break;
            }
            case FEET: {
                humanoidModel.rightLeg.visible = true;
                humanoidModel.leftLeg.visible = true;
            }
        }
    }

    public static interface CopyExtraState {
        public void copyPropertiesFrom(HumanoidModel<LivingEntity> var1);
    }
}

