/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockStateIdCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register(LiteralArgumentBuilder<CommandSourceStack> bnContext) {
        return (LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)Commands.literal((String)"blockstate_id").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"id", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(BlockStateIdCommand::printBlockState)));
    }

    private static int printBlockState(CommandContext<CommandSourceStack> ctx) {
        int id = IntegerArgumentType.getInteger(ctx, (String)"id");
        BlockState state = Block.stateById((int)id);
        if (state == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("No blockstate for id " + id)));
            return 0;
        }
        String blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
        StringBuilder props = new StringBuilder();
        state.getValues().forEach((property, value) -> {
            if (props.length() > 0) {
                props.append(",");
            }
            props.append(property.getName()).append("=").append(value);
        });
        Object display = props.length() > 0 ? blockId + "[" + String.valueOf(props) + "]" : blockId;
        int canonicalId = Block.BLOCK_STATE_REGISTRY.getId((Object)state);
        if (canonicalId >= 0 && canonicalId != id) {
            display = (String)display + " (canonical id: " + canonicalId + ")";
        }
        MutableComponent result = Component.literal((String)("BlockState id " + id + ": ")).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE));
        result.append((Component)Component.literal((String)display).setStyle(Style.EMPTY.withBold(Boolean.valueOf(false)).withColor(ChatFormatting.WHITE)));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> result, false);
        return 1;
    }
}

