/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.integration;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.bclib.BCLib;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.tag.api.TagManager;

public abstract class ModIntegration {
    private final ModCore C;

    public void init() {
    }

    public void initDatagen() {
    }

    public ModIntegration(ModCore modCore) {
        this.C = modCore;
    }

    public ResourceLocation getID(String name) {
        return this.C.mk(name);
    }

    public ResourceKey<PlacedFeature> getFeatureKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)this.getID(name));
    }

    public Block getBlock(String name) {
        return (Block)BuiltInRegistries.BLOCK.get(this.getID(name));
    }

    public Item getItem(String name) {
        return (Item)BuiltInRegistries.ITEM.get(this.getID(name));
    }

    public BlockState getDefaultState(String name) {
        return this.getBlock(name).defaultBlockState();
    }

    public ResourceKey<Biome> getKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)this.getID(name));
    }

    public boolean modIsInstalled() {
        return this.C.isLoaded();
    }

    public ConfiguredFeature<?, ?> getConfiguredFeature(String name) {
        return null;
    }

    public Holder<Biome> getBiome(String name) {
        return null;
    }

    public Class<?> getClass(String path) {
        Class<?> cl;
        block2: {
            cl = null;
            try {
                cl = Class.forName(path);
            }
            catch (ClassNotFoundException e) {
                BCLib.LOGGER.error(e.getMessage());
                if (!BCLib.isDevEnvironment()) break block2;
                e.printStackTrace();
            }
        }
        return cl;
    }

    public <T> T getStaticFieldValue(Class<?> cl, String name) {
        if (cl != null) {
            try {
                Field field = cl.getDeclaredField(name);
                if (field != null) {
                    return (T)field.get(null);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object getFieldValue(Class<?> cl, String name, Object classInstance) {
        if (cl != null) {
            try {
                Field field = cl.getDeclaredField(name);
                if (field != null) {
                    return field.get(classInstance);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Method getMethod(Class<?> cl, String functionName, Class<?> ... args) {
        block3: {
            if (cl != null) {
                try {
                    return cl.getMethod(functionName, args);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    BCLib.LOGGER.error(e.getMessage());
                    if (!BCLib.isDevEnvironment()) break block3;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public Object executeMethod(Object instance, Method method, Object ... args) {
        block3: {
            if (method != null) {
                try {
                    return method.invoke(instance, args);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    BCLib.LOGGER.error(e.getMessage());
                    if (!BCLib.isDevEnvironment()) break block3;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public Object getAndExecuteStatic(Class<?> cl, String functionName, Object ... args) {
        if (cl != null) {
            Class[] classes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                classes[i] = args[i].getClass();
            }
            Method method = this.getMethod(cl, functionName, classes);
            return this.executeMethod(null, method, args);
        }
        return null;
    }

    public <T> T getAndExecuteRuntime(Class<?> cl, Object instance, String functionName, Object ... args) {
        if (instance != null) {
            Class[] classes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                classes[i] = args[i].getClass();
            }
            Method method = this.getMethod(cl, functionName, classes);
            return (T)this.executeMethod(instance, method, args);
        }
        return null;
    }

    public Object newInstance(Class<?> cl, Object ... args) {
        if (cl != null) {
            for (Constructor<?> constructor : cl.getConstructors()) {
                if (constructor.getParameterCount() != args.length) continue;
                try {
                    return constructor.newInstance(args);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    BCLib.LOGGER.error(e.getMessage());
                    if (!BCLib.isDevEnvironment()) continue;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public TagKey<Item> getItemTag(String name) {
        return TagManager.ITEMS.makeTag(this.C, name);
    }

    public TagKey<Block> getBlockTag(String name) {
        return TagManager.BLOCKS.makeTag(this.C, name);
    }
}

