/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.integration.emi;

import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.blocks.LeveledAnvilBlock;
import org.betterx.bclib.integration.emi.EMIAlloyingRecipe;
import org.betterx.bclib.integration.emi.EMIAnvilRecipe;
import org.betterx.bclib.integration.emi.EMIAnvilRecipeCategory;
import org.betterx.bclib.interfaces.AlloyingRecipeWorkstation;
import org.betterx.wover.core.api.Logger;

public class EMIPlugin
implements EmiPlugin {
    private static boolean didInit = false;
    private static int maxAnvilLevel = 1;
    public static final ResourceLocation BCL_SIMPLIFIED_SPRITES = BCLib.makeID("textures/gui/widgets.png");
    public static EmiStack END_ALLOYING_WORKSTATION;
    public static EmiRecipeCategory END_ALLOYING_CATEGORY;
    public static EmiRecipeCategory[] ANVIL_CATEGORIES;
    public static EmiStack[] ANVIL_WORKSTATIONS;

    public static EmiTexture getSprite(int u, int v) {
        return new EmiTexture(BCL_SIMPLIFIED_SPRITES, u, v, 16, 16, 16, 16, 32, 32);
    }

    public void lazyInit() {
        if (!didInit) {
            didInit = true;
            this.lazyInitAlloyingCategory();
            this.lazyInitAnvilCategories();
        }
    }

    private void lazyInitAlloyingCategory() {
        ItemStack workstations = AlloyingRecipeWorkstation.getWorkstationIcon();
        if (!workstations.is(Blocks.BARRIER.asItem())) {
            END_ALLOYING_WORKSTATION = EmiStack.of((ItemStack)workstations);
            END_ALLOYING_CATEGORY = new EmiRecipeCategory(BCLib.makeID("alloying"), (EmiRenderable)END_ALLOYING_WORKSTATION, (EmiRenderable)EMIPlugin.getSprite(16, 0));
        }
    }

    private void lazyInitAnvilCategories() {
        if (ANVIL_CATEGORIES == null) {
            maxAnvilLevel = Math.max(1, LeveledAnvilBlock.getAnvils().stream().map(LeveledAnvilBlock::getAnvilCraftingLevel).reduce(0, Math::max));
            ANVIL_CATEGORIES = new EmiRecipeCategory[maxAnvilLevel + 1];
            ANVIL_WORKSTATIONS = new EmiStack[maxAnvilLevel + 1];
            for (int anvilLevel = 0; anvilLevel <= maxAnvilLevel; ++anvilLevel) {
                int finalAnvilLevel = anvilLevel;
                EMIPlugin.ANVIL_WORKSTATIONS[anvilLevel] = EmiStack.of((ItemLike)((ItemLike)LeveledAnvilBlock.getAnvils().stream().filter(b -> LeveledAnvilBlock.canHandle(b, finalAnvilLevel)).sorted(Comparator.comparingInt(LeveledAnvilBlock::getAnvilCraftingLevel)).findFirst().orElse(Blocks.BARRIER)));
                EMIPlugin.ANVIL_CATEGORIES[anvilLevel] = new EMIAnvilRecipeCategory(BCLib.makeID("anvil_" + anvilLevel), (EmiRenderable)ANVIL_WORKSTATIONS[anvilLevel], (EmiRenderable)EMIPlugin.getSprite(0, 0), anvilLevel);
                if (anvilLevel <= 0 || !ANVIL_WORKSTATIONS[anvilLevel].isEqual(ANVIL_WORKSTATIONS[anvilLevel - 1])) continue;
                EMIPlugin.ANVIL_WORKSTATIONS[anvilLevel - 1] = ANVIL_WORKSTATIONS[anvilLevel];
                EMIPlugin.ANVIL_CATEGORIES[anvilLevel - 1] = ANVIL_CATEGORIES[anvilLevel];
            }
        }
    }

    public void register(EmiRegistry emiRegistry) {
        this.lazyInit();
        RecipeManager manager = emiRegistry.getRecipeManager();
        if (END_ALLOYING_CATEGORY != null && END_ALLOYING_WORKSTATION != null) {
            emiRegistry.addCategory(END_ALLOYING_CATEGORY);
            emiRegistry.addWorkstation(END_ALLOYING_CATEGORY, (EmiIngredient)END_ALLOYING_WORKSTATION);
            EMIAlloyingRecipe.addAllRecipes(emiRegistry, manager);
        }
        if (ANVIL_CATEGORIES != null && ANVIL_WORKSTATIONS != null && ANVIL_CATEGORIES.length > 0) {
            for (int i = 0; i <= maxAnvilLevel; ++i) {
                emiRegistry.addCategory(ANVIL_CATEGORIES[i]);
                emiRegistry.addWorkstation(ANVIL_CATEGORIES[i], (EmiIngredient)ANVIL_WORKSTATIONS[i]);
            }
            EMIAnvilRecipe.addAllRecipes(emiRegistry, manager);
        }
    }

    public static <C extends RecipeInput, T extends Recipe<C>, E extends EmiRecipe> void addAllRecipes(EmiRegistry emiRegistry, RecipeManager manager, Logger logger, RecipeType<T> recipeType, Function<RecipeHolder<T>, E> createRecipe) {
        EMIPlugin.addAllRecipes(emiRegistry, manager, logger, recipeType, _ignored -> null, (recipe, _ignored) -> (EmiRecipe)createRecipe.apply((RecipeHolder)recipe));
    }

    public static <C extends RecipeInput, T extends Recipe<C>, E extends EmiRecipe, V> void addAllRecipes(EmiRegistry emiRegistry, RecipeManager manager, Logger logger, RecipeType<T> recipeType, Function<RecipeHolder<T>, List<V>> variantSupplier, BiFunction<RecipeHolder<T>, V, E> createRecipe) {
        for (RecipeHolder recipe : manager.getAllRecipesFor(recipeType)) {
            List<V> variants = variantSupplier.apply(recipe);
            if (variants == null) {
                emiRegistry.addRecipe((EmiRecipe)createRecipe.apply(recipe, null));
                continue;
            }
            for (V variantData : variants) {
                try {
                    emiRegistry.addRecipe((EmiRecipe)createRecipe.apply(recipe, variantData));
                }
                catch (Exception e) {
                    logger.error("Exception when parsing vanilla recipe " + String.valueOf(recipe.id()), e);
                }
            }
        }
    }

    static EmiRecipeCategory getAnvilCategoryForLevel(int anvilLevel) {
        anvilLevel = Math.max(0, Math.min(ANVIL_CATEGORIES.length - 1, anvilLevel));
        return ANVIL_CATEGORIES[anvilLevel];
    }
}

