/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.client;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.ItemCombinerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.item.ItemStack;
import org.betterx.bclib.interfaces.AnvilScreenHandlerExtended;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilScreen.class})
public class AnvilScreenMixin
extends ItemCombinerScreen<AnvilMenu> {
    @Shadow
    private EditBox name;
    @Shadow
    @Final
    private static ResourceLocation ANVIL_LOCATION;
    @Unique
    private final List<AbstractWidget> bcl_buttons = Lists.newArrayList();

    public AnvilScreenMixin(AnvilMenu handler, Inventory playerInventory, Component title) {
        super((ItemCombinerMenu)handler, playerInventory, title, ANVIL_LOCATION);
    }

    @Overwrite
    protected void renderErrorIcon(GuiGraphics guiGraphics, int i, int j) {
        if (this.bcl_hasRecipeError()) {
            guiGraphics.blit(ANVIL_LOCATION, i + 65, j + 46, this.imageWidth, 0, 28, 21);
        }
    }

    @Unique
    private boolean bcl_hasRecipeError() {
        return false;
    }

    @Inject(method={"subInit"}, at={@At(value="TAIL")})
    protected void be_subInit(CallbackInfo info) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.bcl_buttons.clear();
        this.bcl_buttons.add((AbstractWidget)Button.builder((Component)Component.literal((String)"<"), b -> this.be_previousRecipe()).bounds(x + 8, y + 45, 15, 20).build());
        this.bcl_buttons.add((AbstractWidget)Button.builder((Component)Component.literal((String)">"), b -> this.be_nextRecipe()).bounds(x + 154, y + 45, 15, 20).build());
        for (AbstractWidget widget : this.bcl_buttons) {
            this.addWidget((GuiEventListener)widget);
        }
    }

    @Inject(method={"renderFg"}, at={@At(value="TAIL")})
    protected void be_renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta, CallbackInfo info) {
        this.bcl_buttons.forEach(button -> button.render(guiGraphics, mouseX, mouseY, delta));
    }

    @Inject(method={"slotChanged"}, at={@At(value="HEAD")}, cancellable=true)
    public void be_onSlotUpdate(AbstractContainerMenu handler, int slotId, ItemStack stack, CallbackInfo info) {
        AnvilScreenHandlerExtended anvilHandler = (AnvilScreenHandlerExtended)handler;
        if (anvilHandler.bcl_getCurrentRecipe() != null) {
            if (anvilHandler.bcl_getRecipes().size() > 1) {
                this.bcl_buttons.forEach(button -> {
                    button.visible = true;
                });
            } else {
                this.bcl_buttons.forEach(button -> {
                    button.visible = false;
                });
            }
            this.name.setValue("");
            info.cancel();
        } else {
            this.bcl_buttons.forEach(button -> {
                button.visible = false;
            });
        }
    }

    @Unique
    private void be_nextRecipe() {
        ((AnvilScreenHandlerExtended)this.menu).be_nextRecipe();
    }

    @Unique
    private void be_previousRecipe() {
        ((AnvilScreenHandlerExtended)this.menu).be_previousRecipe();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.minecraft != null) {
            for (AbstractWidget elem : this.bcl_buttons) {
                if (!elem.visible || !elem.mouseClicked(mouseX, mouseY, button) || this.minecraft.gameMode == null) continue;
                int i = this.bcl_buttons.indexOf(elem);
                this.minecraft.gameMode.handleInventoryButtonClick(((AnvilMenu)this.menu).containerId, i);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

