/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.common;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.IdMapper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.BCLib;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IdMapper.class})
public class IdMapperDebugMixin<T> {
    private static final int MAX_LOGS = 20;
    private static final AtomicInteger DUP_LOGS = new AtomicInteger();
    @Shadow
    private Reference2IntMap<T> tToId;
    @Shadow
    private List<T> idToT;

    @Inject(method={"addMapping"}, at={@At(value="HEAD")}, cancellable=true)
    private void bclib_logDuplicate(T value, int id, CallbackInfo ci) {
        T existingAtId;
        if (!(value instanceof BlockState)) {
            return;
        }
        BlockState state = (BlockState)value;
        int existingId = this.tToId.getInt(value);
        if (existingId != -1 && existingId != id) {
            if (IdMapperDebugMixin.shouldLog()) {
                IdMapperDebugMixin.logRemap(state, existingId, id);
            }
            ci.cancel();
            return;
        }
        if (existingId != -1) {
            ci.cancel();
            return;
        }
        if (id < this.idToT.size() && (existingAtId = this.idToT.get(id)) != null && existingAtId != value && existingAtId instanceof BlockState) {
            BlockState other = (BlockState)existingAtId;
            if (IdMapperDebugMixin.shouldLog()) {
                IdMapperDebugMixin.logOverwrite(state, other, id);
            }
            ci.cancel();
        }
    }

    private static boolean shouldLog() {
        int logged = DUP_LOGS.getAndIncrement();
        if (logged < 20) {
            return true;
        }
        if (logged == 20) {
            BCLib.LOGGER.error("BlockState IdMapper log limit reached (20)");
        }
        return false;
    }

    private static void logRemap(BlockState state, int oldId, int newId) {
        ResourceLocation key = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        String name = key == null ? "unknown" : key.toString();
        BCLib.LOGGER.error("BlockState remapped: " + name + " oldId=" + oldId + " newId=" + newId, (Exception)new RuntimeException("BlockState IdMapper duplicate"));
    }

    private static void logOverwrite(BlockState state, BlockState other, int id) {
        ResourceLocation currentKey = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        ResourceLocation otherKey = BuiltInRegistries.BLOCK.getKey((Object)other.getBlock());
        String currentName = currentKey == null ? "unknown" : currentKey.toString();
        String otherName = otherKey == null ? "unknown" : otherKey.toString();
        BCLib.LOGGER.error("BlockState id reused: id=" + id + " new=" + currentName + " old=" + otherName, (Exception)new RuntimeException("BlockState IdMapper overwrite"));
    }
}

