/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.particles;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

@EventBusSubscriber(modid="bclib", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ParticleFactoryRegistry {
    private static final ParticleFactoryRegistry INSTANCE = new ParticleFactoryRegistry();
    private final Map<ParticleType<?>, PendingParticleFactory<?>> factories = new IdentityHashMap();

    private ParticleFactoryRegistry() {
    }

    public static ParticleFactoryRegistry getInstance() {
        return INSTANCE;
    }

    public <T extends ParticleOptions> void register(ParticleType<T> type, PendingParticleFactory<T> factory) {
        this.factories.put(type, factory);
    }

    @SubscribeEvent
    public static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        ParticleFactoryRegistry.INSTANCE.factories.forEach((type, factory) -> ParticleFactoryRegistry.registerFactory(event, type, factory));
    }

    private static void registerFactory(RegisterParticleProvidersEvent event, ParticleType<?> type, PendingParticleFactory<?> factory) {
        event.registerSpriteSet(type, spriteSet -> factory.create(spriteSet));
    }

    public static interface PendingParticleFactory<T extends ParticleOptions> {
        public ParticleProvider<T> create(SpriteSet var1);
    }
}

