/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.bclib.worldgen;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.behaviours.interfaces.BehaviourClimable;
import org.betterx.bclib.behaviours.interfaces.BehaviourImmobile;
import org.betterx.bclib.behaviours.interfaces.BehaviourLeaves;
import org.betterx.bclib.behaviours.interfaces.BehaviourObsidian;
import org.betterx.bclib.behaviours.interfaces.BehaviourOre;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.behaviours.interfaces.BehaviourPortalFrame;
import org.betterx.bclib.behaviours.interfaces.BehaviourSaplingLike;
import org.betterx.bclib.behaviours.interfaces.BehaviourSeedLike;
import org.betterx.bclib.behaviours.interfaces.BehaviourShearablePlant;
import org.betterx.bclib.behaviours.interfaces.BehaviourVine;
import org.betterx.bclib.behaviours.interfaces.BehaviourWaterPlantLike;
import org.betterx.bclib.interfaces.Fuel;
import org.betterx.bclib.interfaces.tools.AddMineableAxe;
import org.betterx.bclib.interfaces.tools.AddMineableHammer;
import org.betterx.bclib.interfaces.tools.AddMineableHoe;
import org.betterx.bclib.interfaces.tools.AddMineablePickaxe;
import org.betterx.bclib.interfaces.tools.AddMineableShears;
import org.betterx.bclib.interfaces.tools.AddMineableShovel;
import org.betterx.bclib.interfaces.tools.AddMineableSword;
import org.betterx.bclib.interfaces.tools.HasMinableBehaviour;
import org.betterx.bclib.interfaces.tools.PreventMineableAdd;
import org.betterx.bclib.registry.FuelRegistry;
import org.betterx.wover.block.api.BlockRegistry;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.WoverAutoProvider;
import org.betterx.wover.datagen.api.WoverTagProvider;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;
import org.betterx.wover.tag.api.predefined.MineableTags;

public class BCLAutoBlockTagProvider
extends WoverTagProvider.ForBlocks
implements WoverAutoProvider {
    public BCLAutoBlockTagProvider(ModCore modCore) {
        super(modCore);
    }

    private static void processBlockCommon(TagBootstrapContext<Block> context, Block block) {
        ResourceLocation location;
        if (!(block instanceof PreventMineableAdd)) {
            if (block instanceof AddMineableShears) {
                context.add((Object)block, new TagKey[]{MineableTags.SHEARS});
            }
            if (block instanceof AddMineableAxe) {
                context.add((Object)block, new TagKey[]{MineableTags.AXE});
            }
            if (block instanceof AddMineablePickaxe) {
                context.add((Object)block, new TagKey[]{MineableTags.PICKAXE});
            }
            if (block instanceof AddMineableShovel) {
                context.add((Object)block, new TagKey[]{MineableTags.SHOVEL});
            }
            if (block instanceof AddMineableHoe) {
                context.add((Object)block, new TagKey[]{MineableTags.HOE});
            }
            if (block instanceof AddMineableSword) {
                context.add((Object)block, new TagKey[]{MineableTags.SWORD});
            }
            if (block instanceof AddMineableHammer) {
                context.add((Object)block, new TagKey[]{MineableTags.HAMMER});
            }
        }
        if (block instanceof BehaviourWaterPlantLike) {
            context.add((Object)block, new TagKey[]{CommonBlockTags.WATER_PLANT});
        }
        if (block instanceof BehaviourPlant || block instanceof BehaviourShearablePlant) {
            context.add((Object)block, new TagKey[]{CommonBlockTags.PLANT});
        }
        if (block instanceof BehaviourVine) {
            context.add((Object)block, new TagKey[]{CommonBlockTags.VINE});
        }
        if (block instanceof BehaviourSeedLike) {
            context.add((Object)block, new TagKey[]{CommonBlockTags.SEEDS});
        }
        if (block instanceof BehaviourSaplingLike) {
            context.add((Object)block, new TagKey[]{CommonBlockTags.SAPLINGS, BlockTags.SAPLINGS});
        }
        if (block instanceof BehaviourClimable) {
            BehaviourClimable c = (BehaviourClimable)block;
            context.add((Object)block, new TagKey[]{BlockTags.CLIMBABLE});
        }
        if (block instanceof BehaviourLeaves) {
            context.add((Object)block, new TagKey[]{BlockTags.LEAVES, CommonBlockTags.LEAVES});
        }
        if (block instanceof BehaviourImmobile) {
            context.add((Object)block, new TagKey[]{CommonBlockTags.IMMOBILE, BlockTags.DRAGON_IMMUNE});
        }
        if (block instanceof BehaviourObsidian) {
            context.add((Object)block, new TagKey[]{CommonBlockTags.IS_OBSIDIAN, BlockTags.DRAGON_IMMUNE, BlockTags.NEEDS_DIAMOND_TOOL});
        }
        if (block instanceof BehaviourPortalFrame) {
            context.add((Object)block, new TagKey[]{CommonBlockTags.NETHER_PORTAL_FRAME});
        }
        if (block instanceof BehaviourOre) {
            context.add((Object)block, new TagKey[]{CommonBlockTags.ORES});
        }
        if (block instanceof Fuel) {
            Fuel fl = (Fuel)block;
            FuelRegistry.INSTANCE.add((ItemLike)block, fl.getFuelTime());
        }
        if (!(location = BuiltInRegistries.BLOCK.getKey((Object)block)).getNamespace().equals("minecraft") && !(block instanceof HasMinableBehaviour) && block.defaultBlockState().requiresCorrectToolForDrops()) {
            BCLib.LOGGER.error("Block " + String.valueOf(block) + "(" + String.valueOf(block.getClass()) + ") has no mineable behaviour!");
        }
    }

    private static void processCommonBlockTags(TagBootstrapContext<Block> context, ModCore modCore) {
        BCLib.C.LOG.debug("Processing Blocks for " + modCore.namespace);
        BlockRegistry.forMod((ModCore)modCore).allBlocks().forEach(block -> BCLAutoBlockTagProvider.processBlockCommon(context, block));
    }

    public void prepareTags(TagBootstrapContext<Block> context) {
        BCLAutoBlockTagProvider.processCommonBlockTags(context, this.modCore);
    }
}

