/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import de.ambertation.wunderlib.WunderLib;
import java.io.File;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.ClientHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class ItemHelper {
    private ItemHelper() {
    }

    public static void renderAll(@NotNull Stream<Item> items, @NotNull File folder) {
        ItemHelper.renderAll(items, 8.0f, folder);
    }

    public static void renderAll(@NotNull Stream<Item> items, float scale, @NotNull File folder) {
        folder.mkdirs();
        items.forEach(item -> {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey(item);
            File subFolder = new File(folder, id.getNamespace());
            subFolder.mkdirs();
            ItemStack stack = new ItemStack((ItemLike)item);
            File file = new File(subFolder, id.getPath() + ".png");
            ItemHelper.renderToFile(stack, scale, file);
        });
    }

    public static void renderToFile(@NotNull ItemLike item, @NotNull File file) {
        ItemHelper.renderToFile(new ItemStack(item), null, 8.0f, file);
    }

    public static void renderToFile(@NotNull ItemStack stack, @NotNull File file) {
        ItemHelper.renderToFile(stack, null, 8.0f, file);
    }

    public static void renderToFile(@NotNull ItemStack stack, float scale, @NotNull File file) {
        ItemHelper.renderToFile(stack, null, scale, file);
    }

    public static void renderToFile(@NotNull ItemStack stack, @Nullable String overlayText, float scale, @NotNull File file) {
        ItemHelper.executeRender(stack, overlayText, scale, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeRender(ItemStack stack, String overlayText, float scale, File file) {
        int size = (int)(16.0f * scale);
        TextureTarget framebuffer = new TextureTarget(size, size, true, Minecraft.ON_OSX);
        RenderTarget mainTarget = Minecraft.getInstance().getMainRenderTarget();
        try {
            framebuffer.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            framebuffer.clear(Minecraft.ON_OSX);
            framebuffer.bindWrite(true);
            ItemHelper.renderItemToFramebuffer(stack, overlayText, scale, (RenderTarget)framebuffer);
            framebuffer.unbindWrite();
            mainTarget.bindWrite(true);
            ItemHelper.writeFramebufferToFile((RenderTarget)framebuffer, file);
        }
        finally {
            framebuffer.destroyBuffers();
            mainTarget.bindWrite(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderItemToFramebuffer(ItemStack stack, String text, float scale, RenderTarget framebuffer) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.assertOnRenderThreadOrInit();
        Lighting.setupFor3DItems();
        RenderSystem.backupProjectionMatrix();
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        try {
            Matrix4f projection = new Matrix4f().setOrtho(0.0f, (float)framebuffer.viewWidth, (float)framebuffer.viewHeight, 0.0f, 1000.0f, ClientHooks.getGuiFarPlane());
            RenderSystem.setProjectionMatrix((Matrix4f)projection, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
            modelViewStack.translation(0.0f, 0.0f, 10000.0f - ClientHooks.getGuiFarPlane());
            RenderSystem.applyModelViewMatrix();
            GuiGraphics guiGraphics = new GuiGraphics(minecraft, minecraft.renderBuffers().bufferSource());
            guiGraphics.fill(0, 0, framebuffer.width, framebuffer.height, 0);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(scale, scale, 1.0f);
            guiGraphics.renderFakeItem(stack, 0, 0);
            if (stack.getCount() > 1 && text == null) {
                text = String.valueOf(stack.getCount());
            }
            if (text != null) {
                guiGraphics.renderItemDecorations(minecraft.font, stack, 0, 0, text);
            }
            guiGraphics.pose().popPose();
            guiGraphics.flush();
        }
        finally {
            modelViewStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.restoreProjectionMatrix();
        }
    }

    private static void writeFramebufferToFile(RenderTarget framebuffer, File file) {
        try {
            NativeImage nativeImage = Screenshot.takeScreenshot((RenderTarget)framebuffer);
            Util.ioPool().execute(() -> {
                try {
                    nativeImage.writeToFile(file);
                    WunderLib.LOGGER.info("Successfully saved item render to: " + file.getAbsolutePath());
                }
                catch (Exception exception) {
                    WunderLib.LOGGER.warn("Couldn't save item render", exception);
                }
                finally {
                    nativeImage.close();
                }
            });
        }
        catch (Exception e) {
            WunderLib.LOGGER.error("Failed to capture item render", e);
        }
    }

    public static void renderToExistingContext(GuiGraphics guiGraphics, ItemStack stack, @Nullable String overlayText, float scale, int x, int y) {
        if (stack.isEmpty()) {
            return;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 0.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.renderFakeItem(stack, 0, 0);
        String text = overlayText;
        if (stack.getCount() > 1 && text == null) {
            text = String.valueOf(stack.getCount());
        }
        if (text != null) {
            guiGraphics.renderItemDecorations(Minecraft.getInstance().font, stack, 0, 0, text);
        }
        guiGraphics.pose().popPose();
    }

    public static void renderItemGrid(GuiGraphics guiGraphics, ItemStack[] items, int startX, int startY, int itemSize, int spacing, int columns) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i].isEmpty()) continue;
            int col = i % columns;
            int row = i / columns;
            int x = startX + col * (itemSize + spacing);
            int y = startY + row * (itemSize + spacing);
            float scale = (float)itemSize / 16.0f;
            ItemHelper.renderToExistingContext(guiGraphics, items[i], null, scale, x, y);
        }
    }

    public static void renderStandardItem(GuiGraphics guiGraphics, ItemStack stack, int x, int y) {
        ItemHelper.renderToExistingContext(guiGraphics, stack, null, 1.0f, x, y);
    }
}

