/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.layout.components.AbstractVanillaComponent;
import de.ambertation.wunderlib.ui.layout.components.AbstractVanillaComponentRenderer;
import de.ambertation.wunderlib.ui.layout.components.render.EditBoxRenderer;
import de.ambertation.wunderlib.ui.layout.values.Value;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Input
extends AbstractVanillaComponent<EditBox, Input> {
    private Consumer<String> responder;
    private BiFunction<String, Integer, FormattedCharSequence> formatter;
    private Predicate<String> filter;
    private String initialValue = "";

    public Input(Value width, Value height, Component component, String initialValue) {
        super(width, height, new EditBoxRenderer(), component);
        this.initialValue = initialValue;
    }

    @Override
    protected EditBox createVanillaComponent() {
        EditBox eb = new EditBox(((AbstractVanillaComponentRenderer)this.renderer).getFont(), 0, 0, this.relativeBounds.width, this.relativeBounds.height, null, this.component);
        if (this.responder != null) {
            eb.setResponder(this.responder);
        }
        if (this.filter != null) {
            eb.setFilter(this.filter);
        }
        if (this.formatter != null) {
            eb.setFormatter(this.formatter);
        }
        eb.setValue(this.initialValue);
        eb.setBordered(true);
        eb.setEditable(true);
        return eb;
    }

    public Input setResponder(Consumer<String> consumer) {
        this.responder = consumer;
        if (this.vanillaComponent != null) {
            ((EditBox)this.vanillaComponent).setResponder(this.responder);
        }
        return this;
    }

    public Input setFormatter(BiFunction<String, Integer, FormattedCharSequence> formatter) {
        this.formatter = formatter;
        if (this.vanillaComponent != null) {
            ((EditBox)this.vanillaComponent).setFormatter(formatter);
        }
        return this;
    }

    public Input setFilter(Predicate<String> filter) {
        this.filter = filter;
        if (this.vanillaComponent != null) {
            ((EditBox)this.vanillaComponent).setFilter(filter);
        }
        return this;
    }

    public String getValue() {
        if (this.vanillaComponent != null) {
            return ((EditBox)this.vanillaComponent).getValue();
        }
        return "";
    }

    public Input setValue(String value) {
        if (this.vanillaComponent != null) {
            ((EditBox)this.vanillaComponent).setValue(value);
        } else {
            this.initialValue = value;
        }
        return this;
    }

    @Override
    protected Component contentComponent() {
        return Component.literal((String)(this.initialValue + ".."));
    }

    @Override
    public void setFocused(boolean bl) {
        super.setFocused(bl);
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        return super.mouseClicked(x, y, button);
    }

    @Override
    public boolean isFocused() {
        return super.isFocused();
    }
}

