/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.api.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function10;
import com.mojang.datafixers.util.Function11;
import com.mojang.datafixers.util.Function12;
import com.mojang.datafixers.util.Function13;
import com.mojang.datafixers.util.Function14;
import com.mojang.datafixers.util.Function15;
import com.mojang.datafixers.util.Function16;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import com.mojang.datafixers.util.Function9;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.biome.Biome;
import org.betterx.wover.biome.api.data.BiomeGenerationDataContainer;
import org.betterx.wover.biome.impl.data.BiomeDataImpl;
import org.betterx.wover.entrypoint.LibWoverBiome;
import org.betterx.wover.state.api.WorldState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomeData {
    public static final MapCodec<BiomeData> CODEC = BiomeData.codec(BiomeData::new);
    public static final KeyDispatchDataCodec<BiomeData> KEY_CODEC = KeyDispatchDataCodec.of(CODEC);
    @NotNull
    public final ResourceKey<Biome> biomeKey;
    public final float fogDensity;
    @NotNull
    public final BiomeGenerationDataContainer generationData;
    protected static int preFinalAccessWarning = 0;

    public BiomeData(float fogDensity, @NotNull ResourceKey<Biome> biome, @NotNull BiomeGenerationDataContainer generationData) {
        this.fogDensity = fogDensity;
        this.biomeKey = biome;
        this.generationData = generationData;
    }

    @NotNull
    public static BiomeData of(ResourceKey<Biome> biome) {
        return new BiomeData(1.0f, biome, BiomeGenerationDataContainer.EMPTY);
    }

    @NotNull
    public static BiomeData tempOf(ResourceKey<Biome> biome) {
        return new BiomeDataImpl.InMemoryBiomeData(1.0f, biome, BiomeGenerationDataContainer.EMPTY);
    }

    public static <T extends BiomeData> MapCodec<T> codec(Function3<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, Function4<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4, P5> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, RecordCodecBuilder<T, P5> p5, Function5<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, P5, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4, (App)p5).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4, P5, P6> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, RecordCodecBuilder<T, P5> p5, RecordCodecBuilder<T, P6> p6, Function6<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, P5, P6, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4, (App)p5, (App)p6).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4, P5, P6, P7> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, RecordCodecBuilder<T, P5> p5, RecordCodecBuilder<T, P6> p6, RecordCodecBuilder<T, P7> p7, Function7<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, P5, P6, P7, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4, (App)p5, (App)p6, (App)p7).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4, P5, P6, P7, P8> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, RecordCodecBuilder<T, P5> p5, RecordCodecBuilder<T, P6> p6, RecordCodecBuilder<T, P7> p7, RecordCodecBuilder<T, P8> p8, Function8<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, P5, P6, P7, P8, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4, (App)p5, (App)p6, (App)p7, (App)p8).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4, P5, P6, P7, P8, P9> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, RecordCodecBuilder<T, P5> p5, RecordCodecBuilder<T, P6> p6, RecordCodecBuilder<T, P7> p7, RecordCodecBuilder<T, P8> p8, RecordCodecBuilder<T, P9> p9, Function9<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, P5, P6, P7, P8, P9, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4, (App)p5, (App)p6, (App)p7, (App)p8, (App)p9).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4, P5, P6, P7, P8, P9, P10> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, RecordCodecBuilder<T, P5> p5, RecordCodecBuilder<T, P6> p6, RecordCodecBuilder<T, P7> p7, RecordCodecBuilder<T, P8> p8, RecordCodecBuilder<T, P9> p9, RecordCodecBuilder<T, P10> p10, Function10<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, P5, P6, P7, P8, P9, P10, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4, (App)p5, (App)p6, (App)p7, (App)p8, (App)p9, (App)p10).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4, P5, P6, P7, P8, P9, P10, P11> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, RecordCodecBuilder<T, P5> p5, RecordCodecBuilder<T, P6> p6, RecordCodecBuilder<T, P7> p7, RecordCodecBuilder<T, P8> p8, RecordCodecBuilder<T, P9> p9, RecordCodecBuilder<T, P10> p10, RecordCodecBuilder<T, P11> p11, Function11<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, P5, P6, P7, P8, P9, P10, P11, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4, (App)p5, (App)p6, (App)p7, (App)p8, (App)p9, (App)p10, (App)p11).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4, P5, P6, P7, P8, P9, P10, P11, P12> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, RecordCodecBuilder<T, P5> p5, RecordCodecBuilder<T, P6> p6, RecordCodecBuilder<T, P7> p7, RecordCodecBuilder<T, P8> p8, RecordCodecBuilder<T, P9> p9, RecordCodecBuilder<T, P10> p10, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, Function12<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, P5, P6, P7, P8, P9, P10, P11, P12, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4, (App)p5, (App)p6, (App)p7, (App)p8, (App)p9, (App)p10, (App)p11, (App)p12).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, RecordCodecBuilder<T, P5> p5, RecordCodecBuilder<T, P6> p6, RecordCodecBuilder<T, P7> p7, RecordCodecBuilder<T, P8> p8, RecordCodecBuilder<T, P9> p9, RecordCodecBuilder<T, P10> p10, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13, Function13<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4, (App)p5, (App)p6, (App)p7, (App)p8, (App)p9, (App)p10, (App)p11, (App)p12, (App)p13).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, RecordCodecBuilder<T, P5> p5, RecordCodecBuilder<T, P6> p6, RecordCodecBuilder<T, P7> p7, RecordCodecBuilder<T, P8> p8, RecordCodecBuilder<T, P9> p9, RecordCodecBuilder<T, P10> p10, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13, RecordCodecBuilder<T, P14> p14, Function14<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4, (App)p5, (App)p6, (App)p7, (App)p8, (App)p9, (App)p10, (App)p11, (App)p12, (App)p13, (App)p14).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, RecordCodecBuilder<T, P5> p5, RecordCodecBuilder<T, P6> p6, RecordCodecBuilder<T, P7> p7, RecordCodecBuilder<T, P8> p8, RecordCodecBuilder<T, P9> p9, RecordCodecBuilder<T, P10> p10, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13, RecordCodecBuilder<T, P14> p14, RecordCodecBuilder<T, P15> p15, Function15<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4, (App)p5, (App)p6, (App)p7, (App)p8, (App)p9, (App)p10, (App)p11, (App)p12, (App)p13, (App)p14, (App)p15).apply((Applicative)instance, factory));
    }

    public static <T extends BiomeData, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16> MapCodec<T> codec(RecordCodecBuilder<T, P4> p4, RecordCodecBuilder<T, P5> p5, RecordCodecBuilder<T, P6> p6, RecordCodecBuilder<T, P7> p7, RecordCodecBuilder<T, P8> p8, RecordCodecBuilder<T, P9> p9, RecordCodecBuilder<T, P10> p10, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13, RecordCodecBuilder<T, P14> p14, RecordCodecBuilder<T, P15> p15, RecordCodecBuilder<T, P16> p16, Function16<Float, ResourceKey<Biome>, BiomeGenerationDataContainer, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, T> factory) {
        BiomeDataImpl.CodecAttributes a = new BiomeDataImpl.CodecAttributes();
        return RecordCodecBuilder.mapCodec(instance -> instance.group(a.t0, a.t1, a.t2, (App)p4, (App)p5, (App)p6, (App)p7, (App)p8, (App)p9, (App)p10, (App)p11, (App)p12, (App)p13, (App)p14, (App)p15, (App)p16).apply((Applicative)instance, factory));
    }

    public KeyDispatchDataCodec<? extends BiomeData> codec() {
        return KEY_CODEC;
    }

    public KeyDispatchDataCodec<? extends BiomeData> networkCodec() {
        return this.codec();
    }

    @Nullable
    public Holder<Biome> biomeHolder() {
        if (WorldState.registryAccess() == null) {
            if (WorldState.allStageRegistryAccess() == null) {
                return null;
            }
            if (preFinalAccessWarning++ < 5) {
                LibWoverBiome.C.log.verboseWarning("Accessing biome holder for " + String.valueOf(this.biomeKey) + " before registry is ready!");
            }
            return WorldState.allStageRegistryAccess().registryOrThrow(Registries.BIOME).getHolder(this.biomeKey).orElse(null);
        }
        return WorldState.registryAccess().registryOrThrow(Registries.BIOME).getHolder(this.biomeKey).orElse(null);
    }

    @Nullable
    public Biome biome() {
        if (WorldState.registryAccess() == null) {
            if (WorldState.allStageRegistryAccess() == null) {
                return null;
            }
            if (preFinalAccessWarning++ < 5) {
                LibWoverBiome.C.log.verboseWarning("Accessing biome for " + String.valueOf(this.biomeKey) + " before registry is ready!");
            }
            return WorldState.allStageRegistryAccess().registryOrThrow(Registries.BIOME).getOptional(this.biomeKey).orElse(null);
        }
        return WorldState.registryAccess().registryOrThrow(Registries.BIOME).getOptional(this.biomeKey).orElse(null);
    }

    public boolean isPickable() {
        return true;
    }

    public float genChance() {
        return 1.0f;
    }

    @ApiStatus.Internal
    public boolean isTemp() {
        return false;
    }

    public boolean isSame(ResourceKey<Biome> biome) {
        return BiomeData.isSame(this.biomeKey, biome);
    }

    public static boolean isSame(ResourceKey<Biome> biomeA, ResourceKey<Biome> biomeB) {
        if (biomeA == null && biomeB == null) {
            return true;
        }
        if (biomeA == null || biomeB == null) {
            return false;
        }
        return biomeA.location().equals((Object)biomeB.location());
    }

    public boolean isSame(BiomeData biome) {
        if (biome == null) {
            return false;
        }
        return this.isSame(biome.biomeKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BiomeData)) {
            return false;
        }
        BiomeData biomeData = (BiomeData)o;
        return Objects.equals(this.biomeKey, biomeData.biomeKey);
    }

    public int hashCode() {
        return Objects.hash(this.biomeKey);
    }

    public boolean isIntendedFor(@Nullable TagKey<Biome> tag) {
        if (this.generationData.intendedPlacement() == null) {
            return tag == null;
        }
        return this.generationData.intendedPlacement().equals(tag);
    }
}

