/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.biome.impl.modification;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class MobSettingsWorker {
    private final MobSpawnSettings mobSettings;
    private final Biome biome;
    private Map<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>> customSpawners;

    public MobSettingsWorker(Biome biome) {
        this.biome = biome;
        this.mobSettings = biome.getMobSettings();
    }

    private void unfreezeSpawners() {
        if (this.customSpawners == null) {
            this.mobSettings.spawners = this.customSpawners = new HashMap<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>>(this.mobSettings.spawners);
        }
    }

    private void freezeSpawners() {
        if (this.customSpawners != null) {
            this.mobSettings.spawners = ImmutableMap.copyOf(this.customSpawners);
            this.customSpawners = null;
        }
    }

    public boolean finished() {
        boolean res = this.customSpawners != null;
        this.freezeSpawners();
        return res;
    }

    public <M extends Mob> void addSpawns(List<MobSpawnSettings.SpawnerData> spawns) {
        Map<MobCategory, List<MobSpawnSettings.SpawnerData>> input = spawns.stream().collect(Collectors.groupingBy(s -> s.type.getCategory()));
        if (input.isEmpty()) {
            return;
        }
        this.unfreezeSpawners();
        for (MobCategory category : input.keySet()) {
            List<MobSpawnSettings.SpawnerData> mutableSpawns;
            WeightedRandomList<MobSpawnSettings.SpawnerData> currentSpawns = this.customSpawners.get(category);
            if (currentSpawns == null) {
                mutableSpawns = input.get(category);
            } else {
                List tmpA = currentSpawns.unwrap();
                List<MobSpawnSettings.SpawnerData> tmpB = input.get(category);
                mutableSpawns = new ArrayList<MobSpawnSettings.SpawnerData>(tmpA.size() + tmpB.size());
                mutableSpawns.addAll(tmpA);
                mutableSpawns.addAll(tmpB);
            }
            this.customSpawners.put(category, (WeightedRandomList<MobSpawnSettings.SpawnerData>)WeightedRandomList.create(mutableSpawns));
        }
    }
}

