/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.datagen.api;

import com.mojang.serialization.Lifecycle;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.registries.RegistryPatchGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.betterx.wover.core.api.ModCore;
import org.betterx.wover.datagen.api.PackBuilder;
import org.betterx.wover.datagen.api.WoverDataProvider;
import org.betterx.wover.datagen.api.WoverLootProvider;
import org.betterx.wover.datagen.api.WoverRecipeGenerator;
import org.betterx.wover.datagen.api.WoverRegistryProvider;
import org.betterx.wover.datagen.impl.WoverDataGenEntryPointImpl;
import org.betterx.wover.entrypoint.LibWoverDatagen;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class WoverDataGenEntryPoint {
    private List<PackBuilder> builders = null;
    private PackBuilder globalBuilder = null;
    private static final Map<Path, RegistryPackContext> REGISTRY_CONTEXTS = new HashMap<Path, RegistryPackContext>();
    private static Path registryContextRoot = null;

    protected WoverDataGenEntryPoint() {
    }

    protected PackBuilder addDatapack(@Nullable ResourceLocation location) {
        PackBuilder res = new PackBuilder(this.modCore(), location);
        this.builders.add(res);
        return res;
    }

    protected abstract void onInitializeProviders(PackBuilder var1);

    protected abstract ModCore modCore();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        WoverDataGenEntryPoint woverDataGenEntryPoint = this;
        synchronized (woverDataGenEntryPoint) {
            if (this.builders == null) {
                LibWoverDatagen.C.LOG.debug("Initializing WoverDataGenEntryPoint:" + this.getClass().getName() + " for " + String.valueOf(this.modCore()));
                this.builders = new LinkedList<PackBuilder>();
                this.globalBuilder = this.addDatapack(null);
                this.addDefaultGlobalProviders(this.globalBuilder);
                this.onInitializeProviders(this.globalBuilder);
            }
        }
    }

    @ApiStatus.Internal
    public final void onGatherData(GatherDataEvent event) {
        if (this.ignoreRun(event)) {
            LibWoverDatagen.C.LOG.debug("Ignoring run for " + String.valueOf(this));
            return;
        }
        this.initialize();
        PackOutput baseOutput = event.getGenerator().getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        for (PackBuilder builder : this.builders) {
            PackOutput packOutput = this.createPackOutput(event, baseOutput, builder.location);
            builder.pack(packOutput);
            RegistryPackContext registryContext = WoverDataGenEntryPoint.getRegistryContext(event, packOutput);
            CompletableFuture<HolderLookup.Provider> registryLookup = registryContext.registryLookup;
            List<WoverRegistryProvider<?>> registryProviders = builder.registryProviders();
            if (!registryProviders.isEmpty()) {
                registryContext.addModCore(builder.modCore);
                registryContext.addRegistryProviders(registryProviders);
                this.onBuildRegistry(registryContext.registryBuilder);
                if (!registryContext.providerAdded) {
                    event.addProvider(registryContext.createProvider());
                    registryContext.providerAdded = true;
                }
            }
            ArrayList<WoverLootProvider> lootProviders = new ArrayList<WoverLootProvider>();
            ArrayList<WoverRecipeGenerator> recipeGenerators = new ArrayList<WoverRecipeGenerator>();
            for (WoverDataProvider<?> provider : builder.providerFactories()) {
                if (provider instanceof WoverRegistryProvider) continue;
                if (provider instanceof WoverLootProvider) {
                    WoverLootProvider lootProvider = (WoverLootProvider)((Object)provider);
                    lootProviders.add(lootProvider);
                    continue;
                }
                if (provider instanceof WoverRecipeGenerator) {
                    WoverRecipeGenerator recipeGenerator = (WoverRecipeGenerator)((Object)provider);
                    recipeGenerators.add(recipeGenerator);
                    continue;
                }
                event.addProvider(provider.getProvider(packOutput, registryLookup, existingFileHelper));
                WoverDataGenEntryPoint.addMultiProviders(event, provider, packOutput, registryLookup, existingFileHelper);
            }
            if (!lootProviders.isEmpty()) {
                List<LootTableProvider.SubProviderEntry> entries = lootProviders.stream().map(WoverLootProvider::toSubProviderEntry).toList();
                event.addProvider((DataProvider)new LootTableProvider(packOutput, Set.of(), entries, registryLookup));
            }
            if (!recipeGenerators.isEmpty()) {
                final List generators = List.copyOf(recipeGenerators);
                String recipeName = builder.modCore.modId + " Recipes" + (String)(builder.location != null ? " [" + String.valueOf(builder.location) + "]" : "");
                RecipeProvider delegate = new RecipeProvider(this, packOutput, registryLookup){

                    protected void buildRecipes(RecipeOutput exporter, HolderLookup.Provider lookup) {
                        generators.forEach(gen -> gen.buildRecipes(lookup, exporter));
                    }
                };
                event.addProvider((DataProvider)new NamedDataProvider(recipeName, (DataProvider)delegate));
            }
            if (builder.datapackBootstrap == null) continue;
            builder.datapackBootstrap.bootstrap(event, packOutput, builder.location);
        }
    }

    private PackOutput createPackOutput(GatherDataEvent event, PackOutput baseOutput, @Nullable ResourceLocation location) {
        if (location == null) {
            return baseOutput;
        }
        Path root = baseOutput.getOutputFolder().resolve("data").resolve(location.getNamespace()).resolve("datapacks").resolve(location.getPath());
        PackOutput packOutput = new PackOutput(root);
        PackMetadataGenerator packMetaProvider = PackMetadataGenerator.forFeaturePack((PackOutput)packOutput, (Component)Component.translatable((String)("pack." + location.getNamespace() + "." + location.getPath() + ".description")));
        event.addProvider((DataProvider)new NamedDataProvider("Pack Metadata [" + String.valueOf(location) + "]", (DataProvider)packMetaProvider));
        return packOutput;
    }

    private static RegistryPackContext getRegistryContext(GatherDataEvent event, PackOutput packOutput) {
        Path root = event.getGenerator().getPackOutput().getOutputFolder();
        if (registryContextRoot == null || !registryContextRoot.equals(root)) {
            REGISTRY_CONTEXTS.clear();
            registryContextRoot = root;
        }
        Path key = packOutput.getOutputFolder();
        return REGISTRY_CONTEXTS.computeIfAbsent(key, path -> new RegistryPackContext(packOutput, event.getLookupProvider()));
    }

    private static void addMultiProviders(GatherDataEvent event, WoverDataProvider<?> provider, PackOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture, ExistingFileHelper existingFileHelper) {
        Object wpp;
        if (provider instanceof WoverDataProvider.Secondary) {
            wpp = (WoverDataProvider.Secondary)((Object)provider);
            event.addProvider(wpp.getSecondaryProvider(output, registriesFuture, existingFileHelper));
        }
        if (provider instanceof WoverDataProvider.Tertiary) {
            wpp = (WoverDataProvider.Tertiary)((Object)provider);
            event.addProvider(wpp.getTertiaryProvider(output, registriesFuture, existingFileHelper));
        }
    }

    private void addDefaultGlobalProviders(PackBuilder globalPack) {
        WoverDataGenEntryPointImpl.addDefaultGlobalProviders(globalPack);
    }

    protected void onBuildRegistry(RegistrySetBuilder registryBuilder) {
    }

    public static <T extends DataProvider> void registerAutoProvider(PackBuilder.ProviderFactory<T> providerFactory) {
        WoverDataGenEntryPointImpl.registerAutoProvider(providerFactory);
    }

    protected boolean ignoreRun(GatherDataEvent event) {
        return !WoverDataGenEntryPoint.runsForMod(this.modCore(), event.getMods());
    }

    public static boolean runsForMod(ModCore modCore, Set<String> mods) {
        if (mods == null || mods.isEmpty()) {
            return true;
        }
        return mods.contains(modCore.modId) || mods.contains(modCore.namespace);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + String.valueOf(this.modCore());
    }

    private static final class RegistryPackContext {
        private final PackOutput packOutput;
        private final RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        private final Map<ResourceKey<?>, RegistryBootstrapGroup> bootstrapGroups = new LinkedHashMap();
        private final CompletableFuture<RegistrySetBuilder.PatchedRegistries> patchedRegistries;
        private final CompletableFuture<HolderLookup.Provider> registryLookup;
        private final Set<String> modIds = new HashSet<String>();
        private boolean providerAdded = false;

        private RegistryPackContext(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> baseLookup) {
            this.packOutput = packOutput;
            this.patchedRegistries = RegistryPatchGenerator.createLookup(baseLookup, (RegistrySetBuilder)this.registryBuilder);
            this.registryLookup = this.patchedRegistries.thenApply(RegistrySetBuilder.PatchedRegistries::full);
        }

        private void addModCore(ModCore modCore) {
            this.modIds.add(modCore.modId);
            if (!modCore.modId.equals(modCore.namespace)) {
                this.modIds.add(modCore.namespace);
            }
        }

        private void addRegistryProviders(List<? extends WoverRegistryProvider<?>> registryProviders) {
            RegistrySetBuilderCollector collector = new RegistrySetBuilderCollector();
            registryProviders.forEach(provider -> provider.buildRegistry(collector));
            collector.entries().forEach(this::addBootstraps);
        }

        private void addBootstraps(ResourceKey<?> registryKey, List<RegistryBootstrapEntry<?>> entries) {
            for (RegistryBootstrapEntry<?> entry : entries) {
                this.addBootstrap(registryKey, entry.lifecycle, entry.bootstrap);
            }
        }

        private void addBootstrap(ResourceKey registryKey, @Nullable Lifecycle lifecycle, RegistrySetBuilder.RegistryBootstrap bootstrap) {
            RegistryBootstrapGroup group = this.bootstrapGroups.get(registryKey);
            if (group == null) {
                RegistryBootstrapGroup newGroup = new RegistryBootstrapGroup(lifecycle);
                this.bootstrapGroups.put(registryKey, newGroup);
                RegistrySetBuilder.RegistryBootstrap combined = context -> {
                    for (RegistrySetBuilder.RegistryBootstrap<?> entry : newGroup.bootstraps) {
                        entry.run(context);
                    }
                };
                if (newGroup.lifecycle != null) {
                    this.registryBuilder.add(registryKey, newGroup.lifecycle, combined);
                } else {
                    this.registryBuilder.add(registryKey, combined);
                }
                group = newGroup;
            }
            group.bootstraps.add(bootstrap);
        }

        private DataProvider createProvider() {
            return new DeferredRegistryProvider(this.packOutput, this.patchedRegistries, this.modIds);
        }
    }

    private record NamedDataProvider(String name, DataProvider delegate) implements DataProvider
    {
        public CompletableFuture<?> run(CachedOutput output) {
            return this.delegate.run(output);
        }

        public String getName() {
            return this.name;
        }
    }

    private static final class RegistrySetBuilderCollector
    extends RegistrySetBuilder {
        private final Map<ResourceKey<?>, List<RegistryBootstrapEntry<?>>> entries = new LinkedHashMap();

        private RegistrySetBuilderCollector() {
        }

        public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> registryKey, RegistrySetBuilder.RegistryBootstrap<T> bootstrap) {
            this.addEntry(registryKey, null, bootstrap);
            return this;
        }

        public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> registryKey, Lifecycle lifecycle, RegistrySetBuilder.RegistryBootstrap<T> bootstrap) {
            this.addEntry(registryKey, lifecycle, bootstrap);
            return this;
        }

        private <T> void addEntry(ResourceKey<? extends Registry<T>> registryKey, @Nullable Lifecycle lifecycle, RegistrySetBuilder.RegistryBootstrap<T> bootstrap) {
            this.entries.computeIfAbsent(registryKey, key -> new LinkedList()).add(new RegistryBootstrapEntry<T>(lifecycle, bootstrap));
        }

        private Map<ResourceKey<?>, List<RegistryBootstrapEntry<?>>> entries() {
            return this.entries;
        }
    }

    private static final class RegistryBootstrapEntry<T> {
        @Nullable
        private final Lifecycle lifecycle;
        private final RegistrySetBuilder.RegistryBootstrap<T> bootstrap;

        private RegistryBootstrapEntry(@Nullable Lifecycle lifecycle, RegistrySetBuilder.RegistryBootstrap<T> bootstrap) {
            this.lifecycle = lifecycle;
            this.bootstrap = bootstrap;
        }
    }

    private static final class RegistryBootstrapGroup {
        @Nullable
        private final Lifecycle lifecycle;
        private final List<RegistrySetBuilder.RegistryBootstrap<?>> bootstraps = new LinkedList();

        private RegistryBootstrapGroup(@Nullable Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }
    }

    private static final class DeferredRegistryProvider
    implements DataProvider {
        private final PackOutput output;
        private final CompletableFuture<RegistrySetBuilder.PatchedRegistries> registries;
        private final Set<String> modIds;

        private DeferredRegistryProvider(PackOutput output, CompletableFuture<RegistrySetBuilder.PatchedRegistries> registries, Set<String> modIds) {
            this.output = output;
            this.registries = registries;
            this.modIds = modIds;
        }

        public CompletableFuture<?> run(CachedOutput cache) {
            return new DatapackBuiltinEntriesProvider(this.output, this.registries, this.modIds).run(cache);
        }

        public String getName() {
            return "Registries";
        }
    }
}

