/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.api.placed.modifiers;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.betterx.wover.feature.impl.placed.modifiers.PlacementModifiersImpl;
import org.jetbrains.annotations.NotNull;

public class Offset
extends PlacementModifier {
    private static final Map<Direction, Offset> DIRECTIONS = Maps.newHashMap();
    public static final MapCodec<Offset> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Vec3i.CODEC.fieldOf("blocks").forGetter(cfg -> cfg.offset)).apply((Applicative)instance, Offset::new));
    private final Vec3i offset;

    public Offset(Vec3i offset) {
        this.offset = offset;
    }

    public static Offset inDirection(Direction dir) {
        return DIRECTIONS.get(dir);
    }

    @NotNull
    public Stream<BlockPos> getPositions(PlacementContext placementContext, RandomSource randomSource, BlockPos blockPos) {
        return Stream.of(blockPos.offset(this.offset));
    }

    @NotNull
    public PlacementModifierType<?> type() {
        return PlacementModifiersImpl.OFFSET;
    }

    static {
        for (Direction d : Direction.values()) {
            DIRECTIONS.put(d, new Offset(d.getNormal()));
        }
    }
}

