/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.feature.impl.features;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import org.betterx.wover.feature.api.features.config.TemplateFeatureConfig;
import org.betterx.wover.structure.api.StructureNBT;

public class FeatureTemplateImpl
extends StructureNBT
implements TemplateFeatureConfig.FeatureTemplate {
    public static final Codec<TemplateFeatureConfig.FeatureTemplate> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)ResourceLocation.CODEC.fieldOf("location").forGetter(cfg -> cfg.getLocation()), (App)Codec.INT.fieldOf("offset_y").orElse((Object)0).forGetter(cfg -> cfg.getOffsetY())).apply((Applicative)instance, FeatureTemplateImpl::new));
    public final int offsetY;
    private static final Map<String, FeatureTemplateImpl> READER_CACHE = Maps.newHashMap();

    protected FeatureTemplateImpl(ResourceLocation location, int offsetY) {
        super(location);
        this.offsetY = offsetY;
    }

    public static TemplateFeatureConfig.FeatureTemplate createTemplate(ResourceLocation location) {
        return FeatureTemplateImpl.createTemplate(location, 0);
    }

    public static TemplateFeatureConfig.FeatureTemplate createTemplate(ResourceLocation location, int offsetY) {
        String key = location.toString() + "::" + offsetY;
        return READER_CACHE.computeIfAbsent(key, r -> new FeatureTemplateImpl(location, offsetY));
    }

    public boolean generateIfPlaceable(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        return this.generateIfPlaceable(level, pos, FeatureTemplateImpl.getRandomRotation(random), FeatureTemplateImpl.getRandomMirror(random));
    }

    @Override
    public boolean generateIfPlaceable(ServerLevelAccessor level, BlockPos pos, Rotation r, Mirror m) {
        if (this.canGenerate((LevelAccessor)level, pos, r)) {
            return this.generate(level, pos, r, m);
        }
        return false;
    }

    public boolean generate(ServerLevelAccessor level, BlockPos pos, Rotation r, Mirror m) {
        return this.generateCentered(level, pos.above(this.offsetY), r, m);
    }

    public boolean canGenerate(LevelAccessor level, BlockPos pos, Rotation rotation) {
        if (this.structure == null) {
            return false;
        }
        return !this.containsBedrock(level, pos);
    }

    private boolean containsBedrock(LevelAccessor level, BlockPos startPos) {
        for (int i = 0; i < this.structure.getSize().getY(); i += 2) {
            if (!level.getBlockState(startPos.above(i)).is(Blocks.BEDROCK)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean loaded() {
        return this.structure != null;
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.location;
    }
}

