/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.generator.impl.preset;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.betterx.wover.entrypoint.LibWoverWorldGenerator;
import org.betterx.wover.generator.api.biomesource.end.WoverEndConfig;
import org.betterx.wover.generator.api.biomesource.nether.WoverNetherConfig;
import org.betterx.wover.generator.api.preset.WorldPresets;
import org.betterx.wover.generator.impl.biomesource.end.WoverEndBiomeSource;
import org.betterx.wover.generator.impl.biomesource.nether.WoverNetherBiomeSource;
import org.betterx.wover.generator.impl.chunkgenerator.WoverChunkGenerator;
import org.betterx.wover.legacy.api.LegacyHelper;
import org.betterx.wover.preset.api.WorldPresetManager;
import org.betterx.wover.preset.api.WorldPresetTags;
import org.betterx.wover.preset.api.context.WorldPresetBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PresetRegistryImpl {
    public static final ResourceKey<WorldPreset> WOVER_WORLD = WorldPresetManager.createKey(LibWoverWorldGenerator.C.id("normal"));
    public static final ResourceKey<WorldPreset> WOVER_WORLD_LARGE = WorldPresetManager.createKey(LibWoverWorldGenerator.C.id("large"));
    public static final ResourceKey<WorldPreset> WOVER_WORLD_AMPLIFIED = WorldPresetManager.createKey(LibWoverWorldGenerator.C.id("amplified"));
    public static final ResourceKey<WorldPreset> BCL_WORLD_17 = WorldPresetManager.createKey(LegacyHelper.BCLIB_CORE.id("legacy_17"));

    public static void bootstrapWorldPresets(WorldPresetBootstrapContext ctx) {
        ctx.register(WorldPresets.WOVER_WORLD, PresetRegistryImpl.createNormal(ctx));
        ctx.register(WorldPresets.WOVER_WORLD_LARGE, PresetRegistryImpl.createLarge(ctx));
        ctx.register(WorldPresets.WOVER_WORLD_AMPLIFIED, PresetRegistryImpl.createAmplified(ctx));
        if (LegacyHelper.isLegacyEnabled()) {
            ResourceKey<WorldPreset> BCL_WORLD = WorldPresetManager.createKey(LegacyHelper.BCLIB_CORE.convertNamespace(WorldPresets.WOVER_WORLD));
            ResourceKey<WorldPreset> BCL_WORLD_LARGE = WorldPresetManager.createKey(LegacyHelper.BCLIB_CORE.convertNamespace(WorldPresets.WOVER_WORLD_LARGE));
            ResourceKey<WorldPreset> BCL_WORLD_AMPLIFIED = WorldPresetManager.createKey(LegacyHelper.BCLIB_CORE.convertNamespace(WorldPresets.WOVER_WORLD_AMPLIFIED));
            ctx.register(BCL_WORLD_17, PresetRegistryImpl.createLegacy(ctx));
            ctx.register(BCL_WORLD, PresetRegistryImpl.createNormal(ctx));
            ctx.register(BCL_WORLD_LARGE, PresetRegistryImpl.createLarge(ctx));
            ctx.register(BCL_WORLD_AMPLIFIED, PresetRegistryImpl.createAmplified(ctx));
        }
    }

    public static void bootstrapWorldPresetTags(TagBootstrapContext<WorldPreset> context) {
        context.add(WorldPresetTags.NORMAL, WorldPresets.WOVER_WORLD, WorldPresets.WOVER_WORLD_AMPLIFIED, WorldPresets.WOVER_WORLD_LARGE);
    }

    @NotNull
    public static LevelStem makeWoverNetherStem(WorldPresetBootstrapContext.StemContext context, WoverNetherConfig config) {
        WoverNetherBiomeSource netherSource = new WoverNetherBiomeSource(config);
        return new LevelStem(context.dimension, (ChunkGenerator)new WoverChunkGenerator(netherSource, context.generatorSettings));
    }

    public static LevelStem makeWoverEndStem(WorldPresetBootstrapContext.StemContext context, WoverEndConfig config) {
        WoverEndBiomeSource endSource = new WoverEndBiomeSource(config);
        return new LevelStem(context.dimension, (ChunkGenerator)new WoverChunkGenerator(endSource, context.generatorSettings));
    }

    private static WorldPreset createLegacy(WorldPresetBootstrapContext ctx) {
        return PresetRegistryImpl.buildPreset(ctx.overworldStem, ctx.netherContext, WoverNetherConfig.MINECRAFT_17, ctx.endContext, WoverEndConfig.MINECRAFT_17);
    }

    private static WorldPreset createAmplified(WorldPresetBootstrapContext ctx) {
        Holder.Reference amplifiedBiomeGenerator = ctx.noiseSettings.getOrThrow(NoiseGeneratorSettings.AMPLIFIED);
        WorldPresetBootstrapContext.StemContext amplifiedNetherContext = WorldPresetBootstrapContext.StemContext.of(ctx.netherContext.dimension, ctx.netherContext.structureSets, (Holder<NoiseGeneratorSettings>)ctx.noiseSettings.getOrThrow(WoverChunkGenerator.AMPLIFIED_NETHER));
        return PresetRegistryImpl.buildPreset(ctx.makeNoiseBasedOverworld(ctx.overworldStem.generator().getBiomeSource(), (Holder<NoiseGeneratorSettings>)amplifiedBiomeGenerator), amplifiedNetherContext, WoverNetherConfig.MINECRAFT_18_AMPLIFIED, ctx.endContext, WoverEndConfig.MINECRAFT_20_AMPLIFIED);
    }

    private static WorldPreset createLarge(WorldPresetBootstrapContext ctx) {
        Holder.Reference largeBiomeGenerator = ctx.noiseSettings.getOrThrow(NoiseGeneratorSettings.LARGE_BIOMES);
        return PresetRegistryImpl.buildPreset(ctx.makeNoiseBasedOverworld(ctx.overworldStem.generator().getBiomeSource(), (Holder<NoiseGeneratorSettings>)largeBiomeGenerator), ctx.netherContext, WoverNetherConfig.MINECRAFT_18_LARGE, ctx.endContext, WoverEndConfig.MINECRAFT_20_LARGE);
    }

    private static WorldPreset createNormal(WorldPresetBootstrapContext ctx) {
        return PresetRegistryImpl.buildPreset(ctx.overworldStem, ctx.netherContext, WoverNetherConfig.DEFAULT, ctx.endContext, WoverEndConfig.DEFAULT);
    }

    private static WorldPreset buildPreset(LevelStem overworldStem, WorldPresetBootstrapContext.StemContext netherContext, WoverNetherConfig netherConfig, WorldPresetBootstrapContext.StemContext endContext, WoverEndConfig endConfig) {
        return WorldPresetManager.of(PresetRegistryImpl.buildDimensionMap(overworldStem, netherContext, netherConfig, endContext, endConfig));
    }

    private static Map<ResourceKey<LevelStem>, LevelStem> buildDimensionMap(LevelStem overworldStem, WorldPresetBootstrapContext.StemContext netherContext, WoverNetherConfig netherConfig, WorldPresetBootstrapContext.StemContext endContext, WoverEndConfig endConfig) {
        return Map.of(LevelStem.OVERWORLD, overworldStem, LevelStem.NETHER, WorldPresets.makeWoverNetherStem(netherContext, netherConfig), LevelStem.END, WorldPresets.makeWoverEndStem(endContext, endConfig));
    }

    @ApiStatus.Internal
    public static void ensureStaticallyLoaded() {
    }
}

