/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.preset.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.betterx.wover.preset.api.WorldPresetInfo;
import org.betterx.wover.preset.api.WorldPresetInfoRegistry;
import org.betterx.wover.util.PriorityLinkedList;
import org.jetbrains.annotations.Nullable;

public class WorldPresetInfoImpl
implements WorldPresetInfo {
    public static final Codec<WorldPresetInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("sort_order", (Object)PriorityLinkedList.DEFAULT_PRIORITY).forGetter(o -> o.sortOrder()), (App)ResourceKey.codec((ResourceKey)Registries.WORLD_PRESET).optionalFieldOf("overworld_preset").forGetter(o -> Optional.ofNullable(o.overworldPreset())), (App)ResourceKey.codec((ResourceKey)Registries.WORLD_PRESET).optionalFieldOf("nether_preset").forGetter(o -> Optional.ofNullable(o.netherPreset())), (App)ResourceKey.codec((ResourceKey)Registries.WORLD_PRESET).optionalFieldOf("end_preset").forGetter(o -> Optional.ofNullable(o.endPreset()))).apply((Applicative)instance, WorldPresetInfoImpl::fromOptionals));
    public static final WorldPresetInfo DEFAULT = new WorldPresetInfoImpl(PriorityLinkedList.DEFAULT_PRIORITY, null, null, null);
    private final int sortOrder;
    @Nullable
    private final ResourceKey<WorldPreset> overworldLike;
    @Nullable
    private final ResourceKey<WorldPreset> netherLike;
    @Nullable
    private final ResourceKey<WorldPreset> endLike;

    private static WorldPresetInfo fromOptionals(Integer sort, Optional<ResourceKey<WorldPreset>> overworld, Optional<ResourceKey<WorldPreset>> nether, Optional<ResourceKey<WorldPreset>> end) {
        return new WorldPresetInfoImpl(sort, (ResourceKey<WorldPreset>)((ResourceKey)overworld.orElse(null)), (ResourceKey<WorldPreset>)((ResourceKey)nether.orElse(null)), (ResourceKey<WorldPreset>)((ResourceKey)end.orElse(null)));
    }

    public WorldPresetInfoImpl(int order) {
        this(order, null, null, null);
    }

    WorldPresetInfoImpl(int sortOrder, @Nullable ResourceKey<WorldPreset> overworldLike, @Nullable ResourceKey<WorldPreset> netherLike, @Nullable ResourceKey<WorldPreset> endLike) {
        this.sortOrder = sortOrder;
        this.overworldLike = overworldLike;
        this.netherLike = netherLike;
        this.endLike = endLike;
    }

    @Override
    public int sortOrder() {
        return this.sortOrder;
    }

    @Override
    @Nullable
    public ResourceKey<WorldPreset> overworldPreset() {
        return this.overworldLike;
    }

    @Override
    @Nullable
    public ResourceKey<WorldPreset> netherPreset() {
        return this.netherLike;
    }

    @Override
    @Nullable
    public ResourceKey<WorldPreset> endPreset() {
        return this.endLike;
    }

    @Override
    @Nullable
    public ResourceKey<WorldPreset> getPresetOverride(ResourceKey<LevelStem> key) {
        if (key.location().equals((Object)LevelStem.OVERWORLD.location())) {
            return this.overworldPreset();
        }
        if (key.location().equals((Object)LevelStem.NETHER.location())) {
            return this.netherPreset();
        }
        if (key.location().equals((Object)LevelStem.END.location())) {
            return this.endPreset();
        }
        return null;
    }

    @Override
    @Nullable
    public ResourceKey<WorldPreset> getPresetOverrideRecursive(ResourceKey<LevelStem> forDimension, int count) {
        ResourceKey<WorldPreset> configuredKey = null;
        ResourceKey<WorldPreset> overrideKey = this.getPresetOverride(forDimension);
        while (overrideKey != null && count > 0) {
            configuredKey = overrideKey;
            overrideKey = WorldPresetInfoRegistry.getFor(configuredKey).getPresetOverride(forDimension);
            --count;
        }
        return configuredKey;
    }
}

