/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.api.sets;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.betterx.wover.structure.api.StructureKey;
import org.betterx.wover.structure.api.builders.BaseStructureBuilder;
import org.betterx.wover.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureSetBuilder {
    @NotNull
    private final ResourceKey<StructureSet> key;
    @NotNull
    private final BootstrapContext<StructureSet> context;
    private final List<Pair<ResourceKey<Structure>, Integer>> structures = new LinkedList<Pair<ResourceKey<Structure>, Integer>>();
    private StructurePlacement placement;

    StructureSetBuilder(@NotNull ResourceKey<StructureSet> key, @NotNull BootstrapContext<StructureSet> context) {
        this.key = key;
        this.context = context;
    }

    public StructureSetBuilder addStructure(ResourceKey<Structure> structure, int weight) {
        this.structures.add(new Pair<ResourceKey<Structure>, Integer>(structure, weight));
        return this;
    }

    public StructureSetBuilder addStructure(ResourceKey<Structure> structure) {
        return this.addStructure((StructureKey)structure, 1);
    }

    public <S extends Structure, T extends BaseStructureBuilder<S, T>, K extends StructureKey<S, T, K>> StructureSetBuilder addStructure(K structure, int weight) {
        return this.addStructure((K)structure.key(), weight);
    }

    public <S extends Structure, T extends BaseStructureBuilder<S, T>, K extends StructureKey<S, T, K>> StructureSetBuilder addStructure(K structure) {
        return this.addStructure(structure, 1);
    }

    public StructureSetBuilder randomPlacement(int spacing, int seperation) {
        return this.randomPlacement().spacing(spacing).separation(seperation).finishPlacement();
    }

    public RandomSpreadStructurePlacementBuilder randomPlacement() {
        return new RandomSpreadStructurePlacementBuilder(this.key);
    }

    public ConcentricRingsStructurePlacementBuilder concentricPlacement() {
        return new ConcentricRingsStructurePlacementBuilder(this.context, this.key);
    }

    public StructureSetBuilder setPlacement(StructurePlacement p) {
        this.placement = p;
        return this;
    }

    public Holder<StructureSet> register() {
        return this.context.register(this.key, (Object)this.build());
    }

    public Holder<StructureSet> directHolder() {
        return Holder.direct((Object)this.build());
    }

    private StructureSet build() {
        if (this.structures.isEmpty()) {
            throw new IllegalStateException("StructureSet " + String.valueOf(this.key.location()) + " must contain at least one structure");
        }
        if (this.placement == null) {
            throw new IllegalStateException("StructureSet " + String.valueOf(this.key.location()) + " define a placement");
        }
        HolderGetter structureRegistry = this.context.lookup(Registries.STRUCTURE);
        if (this.structures.size() == 1) {
            Holder.Reference holder = structureRegistry.getOrThrow((ResourceKey)this.structures.get((int)0).first);
            return new StructureSet((Holder)holder, this.placement);
        }
        return new StructureSet(this.structures.stream().map(p -> StructureSet.entry((Holder)structureRegistry.getOrThrow((ResourceKey)p.first), (int)((Integer)p.second))).toList(), this.placement);
    }

    public class RandomSpreadStructurePlacementBuilder
    extends StructurePlacementBuilder<RandomSpreadStructurePlacementBuilder> {
        protected int spacing;
        protected int separation;
        protected RandomSpreadType spreadType;

        RandomSpreadStructurePlacementBuilder(ResourceKey<StructureSet> baseKey) {
            super(StructureSetBuilder.this, baseKey);
            this.spacing = 32;
            this.separation = 8;
            this.spreadType = RandomSpreadType.LINEAR;
        }

        @NotNull
        public RandomSpreadStructurePlacementBuilder spacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        @NotNull
        public RandomSpreadStructurePlacementBuilder separation(int separation) {
            this.separation = separation;
            return this;
        }

        @NotNull
        public RandomSpreadStructurePlacementBuilder spreadType(@NotNull RandomSpreadType spreadType) {
            this.spreadType = spreadType;
            return this;
        }

        @Override
        public StructureSetBuilder finishPlacement() {
            return StructureSetBuilder.this.setPlacement((StructurePlacement)new RandomSpreadStructurePlacement(this.locateOffset, this.frequencyReductionMethod, this.frequency, this.salt, this.exclusionZone, this.spacing, this.separation, this.spreadType));
        }
    }

    public class ConcentricRingsStructurePlacementBuilder
    extends StructurePlacementBuilder<ConcentricRingsStructurePlacementBuilder> {
        protected int distance;
        protected int spread;
        protected int count;
        @NotNull
        protected TagKey<Biome> preferredBiomes;
        @NotNull
        private final BootstrapContext<StructureSet> context;

        ConcentricRingsStructurePlacementBuilder(@NotNull BootstrapContext<StructureSet> context, ResourceKey<StructureSet> baseKey) {
            super(StructureSetBuilder.this, baseKey);
            this.context = context;
            this.distance = 32;
            this.spread = 3;
            this.count = 128;
            this.preferredBiomes = BiomeTags.STRONGHOLD_BIASED_TO;
        }

        @NotNull
        public ConcentricRingsStructurePlacementBuilder distance(int distance) {
            this.distance = distance;
            return this;
        }

        @NotNull
        public ConcentricRingsStructurePlacementBuilder spread(int spread) {
            this.spread = spread;
            return this;
        }

        @NotNull
        public ConcentricRingsStructurePlacementBuilder count(int count) {
            this.count = count;
            return this;
        }

        @NotNull
        public ConcentricRingsStructurePlacementBuilder preferredBiomes(@NotNull TagKey<Biome> preferredBiomes) {
            this.preferredBiomes = preferredBiomes;
            return this;
        }

        @Override
        public StructureSetBuilder finishPlacement() {
            return StructureSetBuilder.this.setPlacement((StructurePlacement)new ConcentricRingsStructurePlacement(this.locateOffset, this.frequencyReductionMethod, this.frequency, this.salt, this.exclusionZone, this.distance, this.spread, this.count, (HolderSet)this.context.lookup(Registries.BIOME).getOrThrow(this.preferredBiomes)));
        }
    }

    public abstract class StructurePlacementBuilder<R extends StructurePlacementBuilder<R>> {
        protected Vec3i locateOffset = Vec3i.ZERO;
        protected StructurePlacement.FrequencyReductionMethod frequencyReductionMethod = StructurePlacement.FrequencyReductionMethod.DEFAULT;
        protected float frequency = 1.0f;
        protected int salt;
        protected Optional<StructurePlacement.ExclusionZone> exclusionZone = Optional.empty();

        public abstract StructureSetBuilder finishPlacement();

        @NotNull
        public R locateOffset(Vec3i offset) {
            this.locateOffset = offset;
            return (R)this;
        }

        @NotNull
        public R frequencyReductionMethod(@NotNull StructurePlacement.FrequencyReductionMethod method) {
            this.frequencyReductionMethod = method;
            return (R)this;
        }

        @NotNull
        public R frequency(float frequency) {
            this.frequency = frequency;
            return (R)this;
        }

        @NotNull
        public R salt(int salt) {
            this.salt = salt;
            return (R)this;
        }

        @NotNull
        public R exclusionZone(@Nullable StructurePlacement.ExclusionZone exclusionZone) {
            this.exclusionZone = exclusionZone == null ? Optional.empty() : Optional.of(exclusionZone);
            return (R)this;
        }

        protected StructurePlacementBuilder(@NotNull StructureSetBuilder this$0, ResourceKey<StructureSet> baseKey) {
            this.salt = Math.abs(baseKey.location().hashCode());
        }
    }
}

