/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.structure.api.structures;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.wover.structure.api.structures.NoiseColumnWithState;
import org.betterx.wover.structure.api.structures.nbt.RandomNbtStructureElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum StructurePlacement implements StringRepresentable
{
    LAVA(StructurePlacement::findGenerationPointNetherLava),
    SURFACE(StructurePlacement::findGenerationPointSurface),
    LEGACY_FLOOR("floor", StructurePlacement::findGenerationPointNetherFloor),
    LEGACY_CEIL("ceil", StructurePlacement::findGenerationPointNetherFloor),
    NETHER_CEIL(StructurePlacement::findGenerationPointNetherCeil),
    NETHER_SURFACE(StructurePlacement::findGenerationPointNetherFloor),
    NETHER_SURFACE_FLAT_0((a, b, c, d, e) -> StructurePlacement.findGenerationPointNetherFloorFlat(a, b, c, d, e, 0)),
    NETHER_SURFACE_FLAT_2((a, b, c, d, e) -> StructurePlacement.findGenerationPointNetherFloorFlat(a, b, c, d, e, 2)),
    NETHER_SURFACE_FLAT_4((a, b, c, d, e) -> StructurePlacement.findGenerationPointNetherFloorFlat(a, b, c, d, e, 4));

    public static final Codec<StructurePlacement> CODEC;
    protected static final int FAIL_HEIGHT = Integer.MIN_VALUE;
    private final String name;
    public final PlacementFunction placementFunction;

    private StructurePlacement(String name, PlacementFunction placementFunction) {
        this.name = name;
        this.placementFunction = placementFunction;
    }

    private StructurePlacement(PlacementFunction placementFunction) {
        this(null, placementFunction);
    }

    @NotNull
    public String getSerializedName() {
        return this.name == null ? this.name().toLowerCase() : this.name.toLowerCase();
    }

    public static Optional<Structure.GenerationStub> onNetherSurface(int x, int startY, int z, Structure.GenerationContext ctx, BiConsumer<BlockPos, StructurePiecesBuilder> consumer) {
        int y = StructurePlacement.findYDownward(startY, List.of(new BlockPos(x, startY, z)), ctx, BlockBehaviour.BlockStateBase::isAir, state -> Heightmap.Types.WORLD_SURFACE_WG.isOpaque().test(state) && !state.liquid(), 1, 0);
        if (y == Integer.MIN_VALUE) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(x, y, z);
        return Optional.of(new Structure.GenerationStub(pos, builder -> consumer.accept(pos, (StructurePiecesBuilder)builder)));
    }

    public static Optional<Structure.GenerationStub> onNetherCeiling(int x, int startY, int z, Structure.GenerationContext ctx, BiConsumer<BlockPos, StructurePiecesBuilder> consumer) {
        int y = StructurePlacement.findYDownward(startY, List.of(new BlockPos(x, startY, z)), ctx, state -> Heightmap.Types.WORLD_SURFACE_WG.isOpaque().test(state), BlockBehaviour.BlockStateBase::isAir, 1, 0);
        if (y == Integer.MIN_VALUE) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(x, y, z);
        return Optional.of(new Structure.GenerationStub(pos, builder -> consumer.accept(pos, (StructurePiecesBuilder)builder)));
    }

    public static Optional<Structure.GenerationStub> onMinHeightNetherSurface(int x, int startY, int z, List<BlockPos> positions, int maxDeltaY, int airAtOffset, Structure.GenerationContext ctx, BiConsumer<BlockPos, StructurePiecesBuilder> consumer) {
        int minFoundY = Integer.MAX_VALUE;
        int maxFoundY = Integer.MIN_VALUE;
        for (BlockPos testPos : positions) {
            int y = StructurePlacement.findYDownward(startY, List.of(testPos), ctx, BlockBehaviour.BlockStateBase::isAir, state -> Heightmap.Types.WORLD_SURFACE_WG.isOpaque().test(state) && !state.liquid(), 1, airAtOffset);
            if (y == Integer.MIN_VALUE) {
                return Optional.empty();
            }
            if (y < minFoundY) {
                minFoundY = y;
            }
            if (y <= maxFoundY) continue;
            maxFoundY = y;
        }
        if (maxFoundY - minFoundY > maxDeltaY) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(x, minFoundY, z);
        return Optional.of(new Structure.GenerationStub(pos, builder -> consumer.accept(pos, (StructurePiecesBuilder)builder)));
    }

    public static Optional<Structure.GenerationStub> onChunkCenterWorldSurface(Structure.GenerationContext generationContext, Heightmap.Types types, BiConsumer<BlockPos, StructurePiecesBuilder> consumer) {
        ChunkPos chunkPos = generationContext.chunkPos();
        int x = chunkPos.getMiddleBlockX();
        int z = chunkPos.getMiddleBlockZ();
        int y = generationContext.chunkGenerator().getFirstOccupiedHeight(x, z, types, generationContext.heightAccessor(), generationContext.randomState());
        BlockPos pos = new BlockPos(x, y, z);
        return Optional.of(new Structure.GenerationStub(pos, builder -> consumer.accept(pos, (StructurePiecesBuilder)builder)));
    }

    @Nullable
    public static int findYDownward(int startY, List<BlockPos> testColumns, Structure.GenerationContext ctx, Predicate<BlockState> testAir, Predicate<BlockState> testSurface, int minMatches, int airAtOffset) {
        return StructurePlacement.findYDownward(startY, ctx.heightAccessor().getMinBuildHeight() + 4, testColumns, ctx, testAir, testSurface, minMatches, airAtOffset);
    }

    @Nullable
    public static int findYDownward(int startY, int stopY, List<BlockPos> testColumns, Structure.GenerationContext ctx, Predicate<BlockState> testAir, Predicate<BlockState> testSurface, int minMatches, int airAtOffset) {
        List<NoiseColumnWithState> noiseColumns = testColumns.stream().map(p -> new NoiseColumnWithState(ctx.chunkGenerator().getBaseColumn(p.getX(), p.getZ(), ctx.heightAccessor(), ctx.randomState()), startY)).toList();
        int res = Integer.MIN_VALUE;
        block0: for (int y = startY - 1; y > stopY; --y) {
            int matchCount = 0;
            for (NoiseColumnWithState noiseColumn : noiseColumns) {
                BlockState state = noiseColumn.getBlock(y);
                if (testAir.test(noiseColumn.lastState) && testSurface.test(state) && ++matchCount == minMatches) {
                    res = y;
                    break block0;
                }
                noiseColumn.lastState = state;
            }
        }
        if (airAtOffset != 0) {
            int matchCount = 0;
            for (NoiseColumnWithState noiseColumn : noiseColumns) {
                if (!testAir.test(noiseColumn.getBlock(res + airAtOffset)) || ++matchCount != minMatches) continue;
                return res;
            }
            return Integer.MIN_VALUE;
        }
        return res;
    }

    public static boolean hasValidBiomeAtRandomHeight(Structure.GenerationContext ctx, int x, int z) {
        int randomY = ctx.random().nextIntBetweenInclusive(ctx.heightAccessor().getMinBuildHeight(), ctx.heightAccessor().getMaxBuildHeight());
        return StructurePlacement.hasValidBiomeAt(ctx, x, randomY, z);
    }

    public static boolean hasValidBiomeAt(Structure.GenerationContext ctx, int x, int y, int z) {
        return ctx.validBiome().test(ctx.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock((int)x), QuartPos.fromBlock((int)y), QuartPos.fromBlock((int)z), ctx.randomState().sampler()));
    }

    @NotNull
    public static BlockPos getCenter(Mirror mirror, StructureTemplate template) {
        int sx = mirror == Mirror.FRONT_BACK ? -1 : 1;
        int sz = mirror == Mirror.LEFT_RIGHT ? -1 : 1;
        return new BlockPos(sx * template.getSize().getX() / 2, 0, sz * template.getSize().getZ() / 2);
    }

    @NotNull
    private static Optional<Structure.GenerationStub> findGenerationPointSurface(Structure.GenerationContext ctx, Rotation rotation, Mirror mirror, RandomNbtStructureElement element, BiConsumer<BlockPos, StructurePiecesBuilder> consumer) {
        return StructurePlacement.onChunkCenterWorldSurface(ctx, Heightmap.Types.WORLD_SURFACE_WG, consumer);
    }

    @NotNull
    private static Optional<Structure.GenerationStub> findGenerationPointNetherCeil(Structure.GenerationContext ctx, Rotation rotation, Mirror mirror, RandomNbtStructureElement element, BiConsumer<BlockPos, StructurePiecesBuilder> consumer) {
        int z;
        ChunkPos chunkPos = ctx.chunkPos();
        int x = chunkPos.getMiddleBlockX();
        if (!StructurePlacement.hasValidBiomeAtRandomHeight(ctx, x, z = chunkPos.getMiddleBlockZ())) {
            return Optional.empty();
        }
        ChunkGenerator generator = ctx.chunkGenerator();
        int maxHeight = generator.getGenDepth() - 20;
        int seaLevel = generator.getSeaLevel();
        return StructurePlacement.onNetherCeiling(x, Mth.randomBetweenInclusive((RandomSource)ctx.random(), (int)seaLevel, (int)maxHeight), z, ctx, consumer);
    }

    @NotNull
    private static Optional<Structure.GenerationStub> findGenerationPointNetherFloor(Structure.GenerationContext ctx, Rotation rotation, Mirror mirror, RandomNbtStructureElement element, BiConsumer<BlockPos, StructurePiecesBuilder> consumer) {
        int z;
        ChunkPos chunkPos = ctx.chunkPos();
        int x = chunkPos.getMiddleBlockX();
        if (!StructurePlacement.hasValidBiomeAtRandomHeight(ctx, x, z = chunkPos.getMiddleBlockZ())) {
            return Optional.empty();
        }
        ChunkGenerator generator = ctx.chunkGenerator();
        int maxHeight = generator.getGenDepth() - 20;
        int seaLevel = generator.getSeaLevel();
        return StructurePlacement.onNetherSurface(x, Mth.randomBetweenInclusive((RandomSource)ctx.random(), (int)seaLevel, (int)maxHeight), z, ctx, consumer);
    }

    @NotNull
    private static Optional<Structure.GenerationStub> findGenerationPointNetherFloorFlat(Structure.GenerationContext ctx, Rotation rotation, Mirror mirror, RandomNbtStructureElement element, BiConsumer<BlockPos, StructurePiecesBuilder> consumer, int maxDeltaY) {
        int z;
        ChunkPos chunkPos = ctx.chunkPos();
        int x = chunkPos.getMiddleBlockX();
        if (!StructurePlacement.hasValidBiomeAtRandomHeight(ctx, x, z = chunkPos.getMiddleBlockZ())) {
            return Optional.empty();
        }
        ChunkGenerator generator = ctx.chunkGenerator();
        int maxHeight = generator.getGenDepth() - 20;
        int seaLevel = generator.getSeaLevel();
        BlockPos startPos = new BlockPos(x, maxHeight, z);
        StructureTemplate template = ctx.structureTemplateManager().getOrCreate(element.nbtLocation());
        BlockPos center = StructurePlacement.getCenter(mirror, template);
        BoundingBox boundingBox = template.getBoundingBox(startPos, rotation, center, mirror);
        List<BlockPos> list = List.of(new BlockPos(boundingBox.minX(), 0, boundingBox.minZ()), new BlockPos(boundingBox.maxX(), 0, boundingBox.minZ()), new BlockPos(boundingBox.minX(), 0, boundingBox.maxZ()), new BlockPos(boundingBox.maxX(), 0, boundingBox.maxZ()));
        return StructurePlacement.onMinHeightNetherSurface(x, Mth.randomBetweenInclusive((RandomSource)ctx.random(), (int)seaLevel, (int)maxHeight), z, list, maxDeltaY, (int)((double)boundingBox.getYSpan() * 0.8), ctx, consumer);
    }

    @NotNull
    private static Optional<Structure.GenerationStub> findGenerationPointNetherLava(Structure.GenerationContext ctx, Rotation rotation, Mirror mirror, RandomNbtStructureElement element, BiConsumer<BlockPos, StructurePiecesBuilder> consumer) {
        BlockPos center;
        ChunkPos chunkPos = ctx.chunkPos();
        int x = chunkPos.getMiddleBlockX();
        int z = chunkPos.getMiddleBlockZ();
        ChunkGenerator generator = ctx.chunkGenerator();
        int seaLevel = generator.getSeaLevel();
        if (!StructurePlacement.hasValidBiomeAt(ctx, x, seaLevel, z)) {
            return Optional.empty();
        }
        BlockPos startPos = new BlockPos(x, seaLevel, z);
        StructureTemplate template = ctx.structureTemplateManager().getOrCreate(element.nbtLocation());
        BoundingBox boundingBox = template.getBoundingBox(startPos, rotation, center = StructurePlacement.getCenter(mirror, template), mirror);
        List<BlockPos> list = List.of(new BlockPos(boundingBox.minX(), 0, boundingBox.minZ()), new BlockPos(boundingBox.maxX(), 0, boundingBox.minZ()), new BlockPos(boundingBox.minX(), 0, boundingBox.maxZ()), new BlockPos(boundingBox.maxX(), 0, boundingBox.maxZ()));
        int y = StructurePlacement.findYDownward(seaLevel, seaLevel - 2, list, ctx, BlockBehaviour.BlockStateBase::isAir, state -> state.is(Blocks.LAVA), list.size(), 0);
        if (y == Integer.MIN_VALUE) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(x, y, z);
        return Optional.of(new Structure.GenerationStub(pos, builder -> consumer.accept(pos, (StructurePiecesBuilder)builder)));
    }

    static {
        CODEC = StringRepresentable.fromEnum(StructurePlacement::values);
    }

    @FunctionalInterface
    public static interface PlacementFunction {
        public Optional<Structure.GenerationStub> find(Structure.GenerationContext var1, Rotation var2, Mirror var3, RandomNbtStructureElement var4, BiConsumer<BlockPos, StructurePiecesBuilder> var5);
    }
}

