/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.surface.impl.noise;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.betterx.wover.surface.api.noise.NoiseParameterManager;
import org.jetbrains.annotations.ApiStatus;

public class NoiseRegistryImpl {
    private static final Map<ResourceKey<NormalNoise.NoiseParameters>, NormalNoise> noiseIntances = new HashMap<ResourceKey<NormalNoise.NoiseParameters>, NormalNoise>();

    public static ResourceKey<NormalNoise.NoiseParameters> createKey(ResourceLocation loc) {
        return ResourceKey.create((ResourceKey)Registries.NOISE, (ResourceLocation)loc);
    }

    private static NormalNoise createNoise(Registry<NormalNoise.NoiseParameters> registry, RandomSource randomSource, ResourceKey<NormalNoise.NoiseParameters> resourceKey) {
        Holder.Reference holder = registry.getHolderOrThrow(resourceKey);
        return NormalNoise.create((RandomSource)randomSource, (NormalNoise.NoiseParameters)((NormalNoise.NoiseParameters)holder.value()));
    }

    public static NormalNoise getOrCreateNoise(RegistryAccess registryAccess, RandomSource randomSource, ResourceKey<NormalNoise.NoiseParameters> noise) {
        Registry registry = registryAccess.registryOrThrow(Registries.NOISE);
        return noiseIntances.computeIfAbsent(noise, key -> NoiseRegistryImpl.createNoise((Registry<NormalNoise.NoiseParameters>)registry, randomSource, noise));
    }

    public static void register(BootstrapContext<NormalNoise.NoiseParameters> bootstapContext, ResourceKey<NormalNoise.NoiseParameters> resourceKey, int firstOctave, double firstAmplitude, double ... amplitudes) {
        bootstapContext.register(resourceKey, (Object)new NormalNoise.NoiseParameters(firstOctave, firstAmplitude, amplitudes));
    }

    @ApiStatus.Internal
    public static void bootstrap(BootstrapContext<NormalNoise.NoiseParameters> bootstapContext) {
        NoiseRegistryImpl.register(bootstapContext, NoiseParameterManager.ROUGHNESS_NOISE, 2, 1.0, 1.0, 1.0, 1.0, 1.0);
    }
}

