/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.tag.api;

import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import org.betterx.wover.tag.api.BiomeTagRegistry;
import org.betterx.wover.tag.api.TagRegistry;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;
import org.betterx.wover.tag.impl.TagManagerImpl;
import org.betterx.wover.tag.impl.TagRegistryImpl;

public class TagManager {
    public static TagRegistry<Block, TagBootstrapContext<Block>> BLOCKS = TagManagerImpl.BLOCKS;
    public static TagRegistry<Item, ItemTagBootstrapContext> ITEMS = TagManagerImpl.ITEMS;
    public static BiomeTagRegistry BIOMES = TagManagerImpl.BIOMES;
    public static TagRegistryImpl<Enchantment, TagBootstrapContext<Enchantment>> ENCHANTMENTS = TagManagerImpl.ENCHANTMENTS;
    public static TagRegistryImpl<EntityType<?>, TagBootstrapContext<EntityType<?>>> ENTITY_TYPES = TagManagerImpl.ENTITY_TYPES;

    public static <T, P extends TagBootstrapContext<T>> TagRegistry<T, P> registerType(DefaultedRegistry<T> registry) {
        return TagManagerImpl.registerType(registry);
    }

    public static <T, P extends TagBootstrapContext<T>> TagRegistry<T, P> registerType(Registry<T> registry, String directory) {
        return TagManagerImpl.registerType(registry, directory);
    }

    public static <T, P extends TagBootstrapContext<T>> TagRegistry<T, P> registerType(ResourceKey<? extends Registry<T>> registry, String directory, TagRegistry.LocationProvider<T> locationProvider) {
        return TagManagerImpl.registerType(registry, directory, locationProvider);
    }

    public static <T, P extends TagBootstrapContext<T>> TagRegistryImpl<T, P> registerType(ResourceKey<? extends Registry<T>> registry) {
        return TagManagerImpl.registerType(registry);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, TagKey<T>> streamCodec(ResourceKey<Registry<T>> registry) {
        return TagManagerImpl.streamCodec(registry);
    }

    public static boolean isToolWithMineableTag(ItemStack stack, TagKey<Block> tag) {
        DiggerItem dig;
        Tool tool;
        Item item = stack.getItem();
        if (item instanceof DiggerItem && (tool = (Tool)(dig = (DiggerItem)item).components().get(DataComponents.TOOL)) != null) {
            for (Tool.Rule rule : tool.rules()) {
                if (!rule.correctForDrops().orElse(false).booleanValue() || !rule.blocks().unwrapKey().map(key -> key == tag).orElse(false).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }
}

