/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class SortedLinkedList<E>
implements Iterable<E>,
Collection<E> {
    private Node<E> head = null;
    private int size = 0;
    private final Comparator<E> comparator;

    public SortedLinkedList(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean add(E data) {
        if (this.head == null) {
            this.head = new Node<E>(data);
        } else if (this.comparator.compare(data, this.head.data) < 0) {
            this.head = new Node<E>(data, this.head);
        } else {
            Node<E> current = this.head;
            Node<E> previous = null;
            while (current != null && this.comparator.compare(data, current.data) >= 0) {
                previous = current;
                current = current.next;
            }
            previous.next = new Node<E>(data, current);
        }
        ++this.size;
        return true;
    }

    public E remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            Node<E> temp = this.head;
            this.head = this.head.next;
            --this.size;
            return temp.data;
        }
        Node<E> current = this.head;
        Node<E> previous = null;
        for (int i = 0; i < index; ++i) {
            previous = current;
            current = current.next;
        }
        previous.next = current.next;
        --this.size;
        return current.data;
    }

    @Override
    public boolean remove(Object data) {
        if (this.head == null) {
            return false;
        }
        if (this.head.data.equals(data)) {
            this.head = this.head.next;
            --this.size;
            return true;
        }
        Node<E> current = this.head;
        Node<E> previous = null;
        while (current != null && !current.data.equals(data)) {
            previous = current;
            current = current.next;
        }
        if (current != null) {
            previous.next = current.next;
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            changed |= this.add(e);
        }
        return changed;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        boolean changed = false;
        Node<E> current = this.head;
        Node<E> previous = null;
        while (current != null) {
            Node cNext = current.next;
            if (!c.contains(current.data)) {
                if (previous == null) {
                    this.head = cNext;
                } else {
                    previous.next = cNext;
                }
                changed = true;
            }
            previous = current;
            current = cNext;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.head = null;
        this.size = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public boolean contains(Object data) {
        Node<E> current = this.head;
        while (current != null && !current.data.equals(data)) {
            current = current.next;
        }
        return current != null;
    }

    public E get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            return this.head.data;
        }
        Node<E> current = this.head;
        for (int i = 0; i < index; ++i) {
            current = current.next;
        }
        return current.data;
    }

    public E peek() {
        if (this.head == null) {
            return null;
        }
        return this.head.data;
    }

    public E dequeue() {
        if (this.head == null) {
            return null;
        }
        return this.remove(0);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator(this);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Node<E> x = this.head;
        while (x != null) {
            result[i++] = x.data;
            x = x.next;
        }
        return result;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int i = 0;
        T[] result = a;
        Node<E> x = this.head;
        while (x != null) {
            result[i++] = x.data;
            x = x.next;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Node<E> current = this.head;
        while (current != null) {
            sb.append(current.data.toString());
            if (current.next != null) {
                sb.append(", ");
            }
            current = current.next;
        }
        sb.append("]");
        return sb.toString();
    }

    private static class Node<E> {
        public final E data;
        private Node<E> next;

        public Node(E data, Node<E> next) {
            this.data = data;
            this.next = next;
        }

        public Node(E data) {
            this(data, null);
        }
    }

    public class Iterator<E>
    implements java.util.Iterator<E> {
        private Node<E> current;

        public Iterator(SortedLinkedList this$0) {
            this.current = this$0.head;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public E next() {
            Object data = this.current.data;
            this.current = this.current.next;
            return data;
        }
    }
}

