/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.wover.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import org.betterx.wover.util.Pair;

public class Triple<A, B, C>
extends Pair<A, B> {
    public final C third;

    public static <A, B, C> Codec<Triple<A, B, C>> tripleCodec(Codec<A> a, Codec<B> b, Codec<C> c, String first, String second, String third) {
        return RecordCodecBuilder.create(instance -> instance.group((App)a.fieldOf(first).forGetter(o -> o.first), (App)b.fieldOf(second).forGetter(o -> o.second), (App)c.fieldOf(third).forGetter(o -> o.third)).apply((Applicative)instance, Triple::new));
    }

    public Triple(A first, B second, C third) {
        super(first, second);
        this.third = third;
    }

    @Override
    public String toString() {
        return "Triple{first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + ", third=" + String.valueOf(this.third) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Triple)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Triple triple = (Triple)o;
        return Objects.equals(this.third, triple.third);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.third);
    }
}

