/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.api.v2.dataexchange.PacketSender;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDataHandler<T extends CustomPacketPayload> {
    private final boolean originatesOnServer;
    @NotNull
    private final ResourceLocation identifier;
    private ServerPlayer lastMessageSender;

    protected BaseDataHandler(@NotNull ResourceLocation identifier, boolean originatesOnServer) {
        this.originatesOnServer = originatesOnServer;
        this.identifier = identifier;
    }

    public final boolean getOriginatesOnServer() {
        return this.originatesOnServer;
    }

    @NotNull
    public final ResourceLocation getIdentifier() {
        return this.identifier;
    }

    @OnlyIn(value=Dist.CLIENT)
    abstract void receiveFromServer(Minecraft var1, ClientPacketListener var2, T var3, PacketSender var4);

    void receiveFromClient(MinecraftServer server, ServerPlayer player, ServerGamePacketListenerImpl handler, T payload, PacketSender responseSender) {
        this.lastMessageSender = player;
    }

    protected final <M extends CustomPacketPayload> boolean reply(BaseDataHandler<M> message, MinecraftServer server) {
        if (this.lastMessageSender == null) {
            return false;
        }
        message.sendToClient(server, this.lastMessageSender);
        return true;
    }

    abstract void sendToClient(MinecraftServer var1);

    abstract void sendToClient(MinecraftServer var1, ServerPlayer var2);

    @OnlyIn(value=Dist.CLIENT)
    abstract void sendToServer(Minecraft var1);

    protected boolean isBlocking() {
        return false;
    }

    public String toString() {
        return "BasDataHandler{originatesOnServer=" + this.originatesOnServer + ", identifier=" + String.valueOf(this.identifier) + "}";
    }

    public static void writeString(FriendlyByteBuf buf, String s) {
        buf.writeByteArray(s.getBytes(StandardCharsets.UTF_8));
    }

    public static String readString(FriendlyByteBuf buf) {
        byte[] data = buf.readByteArray();
        return new String(data, StandardCharsets.UTF_8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseDataHandler)) {
            return false;
        }
        BaseDataHandler that = (BaseDataHandler)o;
        return this.originatesOnServer == that.originatesOnServer && this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.originatesOnServer, this.identifier);
    }
}

