/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.api.v2.levelgen.structures.StructureNBT;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.api.v2.levelgen.structures.TemplatePiece;

public abstract class TemplateStructure
extends Structure {
    protected final List<Config> configs;

    public static boolean isValidBiome(Structure.GenerationContext context, int yPos) {
        BlockPos blockPos = context.chunkPos().getMiddleBlockPosition(yPos);
        return context.validBiome().test(context.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock((int)blockPos.getX()), QuartPos.fromBlock((int)blockPos.getY()), QuartPos.fromBlock((int)blockPos.getZ()), context.randomState().sampler()));
    }

    public static <T extends TemplateStructure> Codec<T> simpleTemplateCodec(BiFunction<Structure.StructureSettings, List<Config>, T> instancer) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Structure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)ExtraCodecs.nonEmptyList((Codec)Config.CODEC.listOf()).fieldOf("configs").forGetter(ruinedPortalStructure -> ruinedPortalStructure.configs)).apply((Applicative)instance, instancer));
    }

    protected TemplateStructure(Structure.StructureSettings structureSettings, ResourceLocation location, int offsetY, StructurePlacementType type, float chance) {
        this(structureSettings, List.of(new Config(location, offsetY, type, chance)));
    }

    protected TemplateStructure(Structure.StructureSettings structureSettings, List<Config> configs) {
        super(structureSettings);
        this.configs = configs;
    }

    protected Config randomConfig(RandomSource random) {
        if (this.configs.size() > 1) {
            float chanceSum = this.configs.parallelStream().map(c -> Float.valueOf(c.chance())).reduce(Float.valueOf(0.0f), (p, c) -> Float.valueOf(p.floatValue() + c.floatValue())).floatValue();
            float rnd = random.nextFloat() * chanceSum;
            for (Config c2 : this.configs) {
                if (!((rnd -= c2.chance()) <= 0.0f)) continue;
                return c2;
            }
        } else {
            return this.configs.get(0);
        }
        return null;
    }

    protected boolean isLavaPlaceable(BlockState state, BlockState before) {
        return (state == null || state.is(Blocks.AIR)) && before.is(Blocks.LAVA);
    }

    protected boolean isFloorPlaceable(BlockState state, BlockState before) {
        return (state == null || state.is(Blocks.AIR)) && before.isSolid();
    }

    protected int erosion(RandomSource rnd) {
        return 0;
    }

    protected boolean cover(RandomSource rnd) {
        return false;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext ctx) {
        int searchStep;
        int minBaseCount;
        BiPredicate<BlockState, BlockState> isCorrectBase;
        int z;
        Config config = this.randomConfig((RandomSource)ctx.random());
        if (config == null) {
            return Optional.empty();
        }
        ChunkPos chunkPos = ctx.chunkPos();
        int x = chunkPos.getMinBlockX();
        if (!this.hasValidBiomeAtRandomHeight(ctx, x, z = chunkPos.getMinBlockZ())) {
            return Optional.empty();
        }
        WorldGenerationContext worldGenerationContext = new WorldGenerationContext(ctx.chunkGenerator(), ctx.heightAccessor());
        StructureTemplate structureTemplate = ctx.structureTemplateManager().getOrCreate(config.location);
        float minAirRatio = 0.6f;
        if (config.type == StructurePlacementType.LAVA) {
            isCorrectBase = this::isLavaPlaceable;
            minBaseCount = 5;
            searchStep = 1;
        } else if (config.type == StructurePlacementType.CEIL) {
            isCorrectBase = this::isFloorPlaceable;
            minBaseCount = 3;
            searchStep = -1;
        } else {
            isCorrectBase = this::isFloorPlaceable;
            minBaseCount = 3;
            searchStep = 1;
        }
        int seaLevel = ctx.chunkGenerator().getSeaLevel() + (searchStep > 0 ? 0 : structureTemplate.getSize(Rotation.NONE).getY() + config.offsetY);
        int maxHeight = worldGenerationContext.getGenDepth() - 4 - (searchStep > 0 ? structureTemplate.getSize(Rotation.NONE).getY() + config.offsetY : 0);
        BlockPos halfSize = new BlockPos(structureTemplate.getSize().getX() / 2, 0, structureTemplate.getSize().getZ() / 2);
        Rotation rotation = StructureNBT.getRandomRotation((RandomSource)ctx.random());
        Mirror mirror = StructureNBT.getRandomMirror((RandomSource)ctx.random());
        BlockPos.MutableBlockPos centerPos = new BlockPos.MutableBlockPos(x, 0, z);
        BoundingBox boundingBox = structureTemplate.getBoundingBox((BlockPos)centerPos, rotation, halfSize, mirror);
        List<NoiseColumn> noiseColumns = ImmutableList.of((Object)new BlockPos(boundingBox.getCenter().getX(), 0, boundingBox.getCenter().getZ()), (Object)new BlockPos(boundingBox.minX(), 0, boundingBox.minZ()), (Object)new BlockPos(boundingBox.maxX(), 0, boundingBox.minZ()), (Object)new BlockPos(boundingBox.minX(), 0, boundingBox.maxZ()), (Object)new BlockPos(boundingBox.maxX(), 0, boundingBox.maxZ())).stream().map(blockPos -> ctx.chunkGenerator().getBaseColumn(blockPos.getX(), blockPos.getZ(), ctx.heightAccessor(), ctx.randomState())).toList();
        int y = noiseColumns.stream().map(column -> this.findY((NoiseColumn)column, isCorrectBase, searchStep, seaLevel, maxHeight)).reduce(searchStep > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE, (p, c) -> searchStep > 0 ? Math.min(p, c) : Math.max(p, c));
        if (y >= maxHeight || y < seaLevel) {
            return Optional.empty();
        }
        if (!TemplateStructure.isValidBiome(ctx, y)) {
            return Optional.empty();
        }
        int baseCount = noiseColumns.stream().map(column -> isCorrectBase.test(null, column.getBlock(y - searchStep))).filter(b -> b).map(b -> 1).reduce(0, (p, c) -> p + c);
        if (baseCount < minBaseCount) {
            return Optional.empty();
        }
        float airRatio = noiseColumns.stream().map(column -> Float.valueOf(this.airRatio((NoiseColumn)column, y, boundingBox.getYSpan(), searchStep))).reduce(Float.valueOf(0.0f), (p, c) -> Float.valueOf(p.floatValue() + c.floatValue())).floatValue() / (float)noiseColumns.size();
        if (airRatio < 0.6f) {
            return Optional.empty();
        }
        centerPos.setY(y - (searchStep == 1 ? 0 : structureTemplate.getSize(Rotation.NONE).getY()));
        int erosion = this.erosion((RandomSource)ctx.random());
        boolean cover = this.cover((RandomSource)ctx.random());
        return Optional.of(new Structure.GenerationStub((BlockPos)centerPos, structurePiecesBuilder -> structurePiecesBuilder.addPiece((StructurePiece)new TemplatePiece(ctx.structureTemplateManager(), config.location, centerPos.offset(0, config.offsetY, 0), rotation, mirror, halfSize, erosion, cover))));
    }

    private boolean hasValidBiomeAtRandomHeight(Structure.GenerationContext ctx, int x, int z) {
        int randomY = ctx.random().nextIntBetweenInclusive(ctx.heightAccessor().getMinBuildHeight(), ctx.heightAccessor().getMaxBuildHeight());
        Holder holder = ctx.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock((int)x), QuartPos.fromBlock((int)randomY), QuartPos.fromBlock((int)z), ctx.randomState().sampler());
        return ctx.validBiome().test(holder);
    }

    private float airRatio(NoiseColumn column, int y, int height, int searchStep) {
        int airCount = 0;
        for (int i = y; i < y + height && i > y - height; i += searchStep) {
            BlockState state = column.getBlock(i);
            if (!state.isAir() && !state.canBeReplaced()) continue;
            ++airCount;
        }
        return (float)airCount / (float)height;
    }

    private int findY(NoiseColumn column, BiPredicate<BlockState, BlockState> isCorrectBase, int searchStep, int seaLevel, int maxHeight) {
        int y;
        BlockState state = column.getBlock(y - searchStep);
        for (y = searchStep > 0 ? seaLevel : maxHeight - 1; y < maxHeight && y >= seaLevel; y += searchStep) {
            BlockState before = state;
            state = column.getBlock(y);
            if (isCorrectBase.test(state, before)) break;
        }
        return y;
    }

    public record Config(ResourceLocation location, int offsetY, StructurePlacementType type, float chance) {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("location").forGetter(cfg -> cfg.location), (App)Codec.INT.fieldOf("offset_y").orElse((Object)0).forGetter(cfg -> cfg.offsetY), (App)StructurePlacementType.CODEC.fieldOf("placement").orElse((Object)StructurePlacementType.FLOOR).forGetter(cfg -> cfg.type), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(cfg -> Float.valueOf(cfg.chance))).apply((Applicative)instance, Config::new));
    }
}

