/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.interfaces.BehaviourVine;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVineBlock
extends BaseBlockNotFull
implements RenderLayerProvider,
BonemealableBlock,
BehaviourVine,
BlockLootProvider,
BlockModelProvider {
    private static final VoxelShape VOXEL_SHAPE = AbstractVineBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected final int maxGrowLength;
    protected final int spaceBeneath;
    protected final int growChance;

    private static BlockBehaviour.Properties makeProps(BlockBehaviour.Properties properties, int growChance) {
        if (growChance > 0) {
            return properties.randomTicks();
        }
        return properties;
    }

    protected AbstractVineBlock(BlockBehaviour.Properties properties, int maxGrowLength, int spaceBeneath, int growChance) {
        super(AbstractVineBlock.makeProps(properties, growChance));
        this.spaceBeneath = Math.max(0, spaceBeneath);
        this.maxGrowLength = Math.max(1, maxGrowLength);
        this.growChance = growChance;
    }

    protected abstract void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var1);

    protected abstract BlockState makeBottomState(BlockState var1);

    protected abstract BlockState makeMiddleState(BlockState var1);

    protected abstract BlockState makeTopState(BlockState var1);

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        Vec3 vec3d = state.getOffset(view, pos);
        return VOXEL_SHAPE.move(vec3d.x, vec3d.y, vec3d.z);
    }

    public boolean canGenerate(BlockState state, LevelReader world, BlockPos pos) {
        return this.isSupport(state, world, pos);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.isSupport(state, world, pos);
    }

    protected boolean isSupport(BlockState state, LevelReader world, BlockPos pos) {
        BlockState up = world.getBlockState(pos.above());
        return up.is((Block)this) || up.is(BlockTags.LEAVES) || AbstractVineBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN);
    }

    public final BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (world.getBlockState(pos.below()).getBlock() != this) {
            return this.makeBottomState(state);
        }
        if (world.getBlockState(pos.above()).getBlock() != this) {
            return this.makeTopState(state);
        }
        return this.makeMiddleState(state);
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return this.canGrow(level, pos, null);
    }

    protected boolean canGrow(LevelReader level, BlockPos pos, @Nullable BlockPos bottomOrNull) {
        BlockPos bottom;
        BlockPos blockPos = bottom = bottomOrNull == null ? pos : bottomOrNull;
        while (bottomOrNull == null && level.getBlockState(bottom).getBlock() == this) {
            bottom = bottom.below();
        }
        for (int i = 0; i <= this.spaceBeneath; ++i) {
            if (level.getBlockState(bottom.below(i)).isAir()) continue;
            return false;
        }
        BlockPos top = pos;
        while (level.getBlockState(top).getBlock() == this) {
            top = top.above();
        }
        return top.getY() - bottom.getY() <= this.maxGrowLength;
    }

    protected void grow(ServerLevel level, BlockPos pos) {
        if (level.getBlockState(pos.above()).getBlock() != this) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos, this.makeTopState(this.defaultBlockState()));
        } else {
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, pos, this.makeMiddleState(this.defaultBlockState()));
        }
        while (level.getBlockState(pos).getBlock() == this) {
            pos = pos.below();
        }
        BlocksHelper.setWithUpdate((LevelAccessor)level, pos, this.defaultBlockState());
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return this.canGrow((LevelReader)level, pos, null);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.grow(level, pos);
    }

    @Override
    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        return provider.dropWithSilkTouchOrHoeOrShears((ItemLike)this, (NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.createCubeModel((Block)this);
        generator.createFlatItem((Block)this);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        if (this.growChance > 0 && random.nextInt(this.growChance) == 0 && this.canGrow((LevelReader)level, pos, pos.below())) {
            this.grow(level, pos);
        }
    }
}

