/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.client.models.BCLModels;
import org.betterx.bclib.interfaces.tools.AddMineablePickaxe;
import org.betterx.bclib.items.BaseAnvilItem;
import org.betterx.bclib.util.BCLDataComponents;
import org.betterx.bclib.util.LootUtil;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.block.api.CustomBlockItemProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.jetbrains.annotations.ApiStatus;

public abstract class BaseAnvilBlock
extends AnvilBlock
implements AddMineablePickaxe,
CustomBlockItemProvider,
BlockModelProvider {
    public static final IntegerProperty DESTRUCTION = BlockProperties.DESTRUCTION;
    public IntegerProperty durability;

    public BaseAnvilBlock(MapColor color) {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ANVIL).mapColor(color));
    }

    public BaseAnvilBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        this.durability = this.getMaxDurability() != 3 ? IntegerProperty.create((String)"durability", (int)0, (int)this.getMaxDurability()) : BlockProperties.DEFAULT_ANVIL_DURABILITY;
        builder.add(new Property[]{DESTRUCTION, this.durability});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        ResourceLocation id = TextureMapping.getBlockTexture((Block)this);
        TextureMapping mapping = new TextureMapping().put(TextureSlot.FRONT, id.withSuffix("_front")).put(TextureSlot.BACK, id.withSuffix("_back")).put(TextureSlot.BOTTOM, id.withSuffix("_bottom")).put(BCLModels.PANEL, id.withSuffix("_panel"));
        PropertyDispatch.C2 prop = PropertyDispatch.properties((Property)DESTRUCTION, (Property)FACING);
        for (int d = 0; d < 3; ++d) {
            mapping.put(TextureSlot.TOP, id.withSuffix("_top_" + d));
            ResourceLocation model = BCLModels.ANVIL.createWithSuffix((Block)this, "_" + d, mapping, generator.modelOutput());
            prop.select((Comparable)Integer.valueOf(d), (Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.MODEL, (Object)model));
            prop.select((Comparable)Integer.valueOf(d), (Comparable)Direction.EAST, Variant.variant().with(VariantProperties.MODEL, (Object)model).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90));
            prop.select((Comparable)Integer.valueOf(d), (Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.MODEL, (Object)model).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180));
            prop.select((Comparable)Integer.valueOf(d), (Comparable)Direction.WEST, Variant.variant().with(VariantProperties.MODEL, (Object)model).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270));
        }
        generator.acceptBlockState((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)this).with((PropertyDispatch)prop));
        generator.delegateItemModel((Block)this, id.withSuffix("_0"));
    }

    public BlockItem getCustomBlockItem(ResourceLocation blockID, Item.Properties settings) {
        return new BaseAnvilItem((Block)this, settings);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        int destruction = (Integer)state.getValue((Property)DESTRUCTION);
        int durability = (Integer)state.getValue((Property)this.getDurabilityProp());
        int value = destruction * this.getMaxDurability() + durability;
        ItemStack tool = (ItemStack)builder.getParameter(LootContextParams.TOOL);
        if (LootUtil.isCorrectTool((ItemLike)this, state, tool)) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            CustomData.update(BCLDataComponents.ANVIL_ENTITY_DATA, (ItemStack)itemStack, compoundTag -> compoundTag.putInt("destruction", value));
            return Lists.newArrayList((Object[])new ItemStack[]{itemStack});
        }
        return Collections.emptyList();
    }

    public IntegerProperty getDurabilityProp() {
        return this.durability;
    }

    public int getMaxDurability() {
        return 5;
    }

    public BlockState damageAnvilUse(BlockState state, RandomSource random) {
        IntegerProperty durability = this.getDurabilityProp();
        int value = (Integer)state.getValue((Property)durability);
        if (value < this.getMaxDurability()) {
            return (BlockState)state.setValue((Property)durability, (Comparable)Integer.valueOf(value + 1));
        }
        value = (Integer)state.getValue((Property)DESTRUCTION);
        return value < 2 ? (BlockState)((BlockState)state.setValue((Property)DESTRUCTION, (Comparable)Integer.valueOf(value + 1))).setValue((Property)durability, (Comparable)Integer.valueOf(0)) : null;
    }

    public BlockState damageAnvilFall(BlockState state) {
        int destruction = (Integer)state.getValue((Property)DESTRUCTION);
        return destruction < 2 ? (BlockState)state.setValue((Property)DESTRUCTION, (Comparable)Integer.valueOf(destruction + 1)) : null;
    }

    @ApiStatus.Internal
    public static void destroyWhenNull(Level level, BlockPos blockPos, BlockState damaged) {
        if (damaged == null) {
            level.removeBlock(blockPos, false);
            level.levelEvent(1029, blockPos, 0);
        } else {
            level.setBlock(blockPos, damaged, 2);
            level.levelEvent(1030, blockPos, 0);
        }
    }
}

