/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blocks.BaseRotatedPillarBlock;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public abstract class BaseBarkBlock
extends BaseRotatedPillarBlock {
    protected BaseBarkBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        ResourceLocation res = TextureMapping.getBlockTexture((Block)this);
        ResourceLocation log = ResourceLocation.fromNamespaceAndPath((String)res.getNamespace(), (String)res.getPath().replace("_bark", "_log"));
        generator.createRotatedPillar((Block)this, new TextureMapping().put(TextureSlot.SIDE, log.withSuffix("_side")).put(TextureSlot.END, log.withSuffix("_side")));
    }

    public static class Wood
    extends BaseBarkBlock
    implements BehaviourWood,
    BlockTagProvider,
    ItemTagProvider {
        private final boolean flammable;

        public Wood(BlockBehaviour.Properties settings, boolean flammable) {
            super(flammable ? settings.ignitedByLava() : settings);
            this.flammable = flammable;
        }

        public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
            context.add(BlockTags.LOGS, (Object[])new Block[]{this});
            if (this.flammable) {
                context.add(BlockTags.LOGS_THAT_BURN, (Object[])new Block[]{this});
            }
        }

        public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
            context.add(ItemTags.LOGS, new ItemLike[]{this});
            if (this.flammable) {
                context.add(ItemTags.LOGS_THAT_BURN, new ItemLike[]{this});
            }
        }
    }
}

