/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.RuntimeBlockModelProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBarsBlock
extends IronBarsBlock
implements RuntimeBlockModelProvider,
RenderLayerProvider,
BehaviourMetal {
    public BaseBarsBlock(Block source) {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).strength(5.0f, 6.0f).noOcclusion());
    }

    public BaseBarsBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Collections.singletonList(new ItemStack((ItemLike)this));
    }

    public Optional<String> getModelString(String block) {
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)this);
        if (block.contains("item")) {
            return PatternsHelper.createJson(BasePatterns.ITEM_BLOCK, blockId);
        }
        if (block.contains("post")) {
            return PatternsHelper.createJson(BasePatterns.BLOCK_BARS_POST, blockId);
        }
        return PatternsHelper.createJson(BasePatterns.BLOCK_BARS_SIDE, blockId);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return ModelsHelper.createBlockItem(resourceLocation);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation blockId, BlockState blockState) {
        ResourceLocation thisId = BuiltInRegistries.BLOCK.getKey((Object)this);
        String path = blockId.getPath();
        Optional<String> pattern = Optional.empty();
        if (path.endsWith("_post")) {
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_BARS_POST, thisId);
        }
        if (path.endsWith("_side")) {
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_BARS_SIDE, thisId);
        }
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public UnbakedModel getModelVariant(ModelResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        ModelResourceLocation postId = RuntimeBlockModelProvider.remapModelResourceLocation(stateId, blockState, "_post");
        ModelResourceLocation sideId = RuntimeBlockModelProvider.remapModelResourceLocation(stateId, blockState, "_side");
        this.registerBlockModel(postId, postId, blockState, modelCache);
        this.registerBlockModel(sideId, sideId, blockState, modelCache);
        ModelsHelper.MultiPartBuilder builder = ModelsHelper.MultiPartBuilder.create((StateDefinition<Block, BlockState>)this.stateDefinition);
        builder.part(postId.id()).setCondition(state -> (Boolean)state.getValue((Property)NORTH) == false && (Boolean)state.getValue((Property)EAST) == false && (Boolean)state.getValue((Property)SOUTH) == false && (Boolean)state.getValue((Property)WEST) == false).add();
        builder.part(sideId.id()).setCondition(state -> (Boolean)state.getValue((Property)NORTH)).setUVLock(true).add();
        builder.part(sideId.id()).setCondition(state -> (Boolean)state.getValue((Property)EAST)).setTransformation(BlockModelRotation.X0_Y90.getRotation()).setUVLock(true).add();
        builder.part(sideId.id()).setCondition(state -> (Boolean)state.getValue((Property)SOUTH)).setTransformation(BlockModelRotation.X0_Y180.getRotation()).setUVLock(true).add();
        builder.part(sideId.id()).setCondition(state -> (Boolean)state.getValue((Property)WEST)).setTransformation(BlockModelRotation.X0_Y270.getRotation()).setUVLock(true).add();
        return builder.build();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        if (direction.getAxis().isVertical() && stateFrom.getBlock() == this && !stateFrom.equals(state)) {
            return false;
        }
        return super.skipRendering(state, stateFrom, direction);
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public static class Metal
    extends BaseBarsBlock
    implements BehaviourMetal {
        public Metal(Block source) {
            super(source);
        }

        public Metal(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }
}

