/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.client.models.BCLModels;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.wover.block.api.BlockProperties;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.jetbrains.annotations.NotNull;

public abstract class StalactiteBlock
extends BaseBlockNotFull
implements SimpleWaterloggedBlock,
LiquidBlockContainer,
RenderLayerProvider,
BlockModelProvider {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty IS_FLOOR = BlockProperties.IS_FLOOR;
    public static final IntegerProperty SIZE = BlockProperties.SIZE;
    private static final VoxelShape[] SHAPES;

    public StalactiteBlock(Block source) {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).noOcclusion());
    }

    public StalactiteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SIZE, (Comparable)Integer.valueOf(0))).setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{WATERLOGGED, IS_FLOOR, SIZE});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPES[(Integer)state.getValue((Property)SIZE)];
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean water;
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Direction dir = ctx.getClickedFace();
        boolean bl = water = world.getFluidState(pos).getType() == Fluids.WATER;
        if (dir == Direction.DOWN) {
            if (this.isThis((LevelReader)world, pos.above()) || StalactiteBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN)) {
                return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
            }
            if (this.isThis((LevelReader)world, pos.below()) || StalactiteBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.below(), (Direction)Direction.UP)) {
                return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
            }
            return null;
        }
        if (this.isThis((LevelReader)world, pos.below()) || StalactiteBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.below(), (Direction)Direction.UP)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
        }
        if (this.isThis((LevelReader)world, pos.above()) || StalactiteBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.above(), (Direction)Direction.DOWN)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
        }
        return null;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        block6: {
            BlockPos.MutableBlockPos mut;
            boolean hasUp;
            block8: {
                boolean hasDown;
                block7: {
                    int i;
                    hasUp = this.isThis((LevelReader)world, pos.above());
                    hasDown = this.isThis((LevelReader)world, pos.below());
                    mut = new BlockPos.MutableBlockPos();
                    if (!hasUp || !hasDown) break block7;
                    boolean floor = (Boolean)state.getValue((Property)IS_FLOOR);
                    BlockPos second = floor ? pos.above() : pos.below();
                    BlockState bState = world.getBlockState(second);
                    world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)SIZE, (Comparable)Integer.valueOf(1))).setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(floor)));
                    world.setBlockAndUpdate(second, (BlockState)((BlockState)bState.setValue((Property)SIZE, (Comparable)Integer.valueOf(1))).setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(!floor)));
                    bState = state;
                    int startSize = floor ? 1 : 2;
                    mut.set(pos.getX(), pos.getY() + 1, pos.getZ());
                    for (i = 0; i < 8 && this.isThis(bState); ++i) {
                        world.setBlockAndUpdate((BlockPos)mut, (BlockState)((BlockState)bState.setValue((Property)SIZE, (Comparable)Integer.valueOf(Math.min(7, startSize + i)))).setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(false)));
                        mut.setY(mut.getY() + 1);
                        bState = world.getBlockState((BlockPos)mut);
                    }
                    bState = state;
                    startSize = floor ? 2 : 1;
                    mut.set(pos.getX(), pos.getY() - 1, pos.getZ());
                    for (i = 0; i < 8 && this.isThis(bState); ++i) {
                        world.setBlockAndUpdate((BlockPos)mut, (BlockState)((BlockState)bState.setValue((Property)SIZE, (Comparable)Integer.valueOf(Math.min(7, startSize + i)))).setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true)));
                        mut.setY(mut.getY() - 1);
                        bState = world.getBlockState((BlockPos)mut);
                    }
                    break block6;
                }
                if (!hasDown) break block8;
                mut.setX(pos.getX());
                mut.setZ(pos.getZ());
                for (int i = 1; i < 8; ++i) {
                    BlockState state2;
                    int size;
                    mut.setY(pos.getY() - i);
                    if (this.isThis((LevelReader)world, (BlockPos)mut) && (size = ((Integer)(state2 = world.getBlockState((BlockPos)mut)).getValue((Property)SIZE)).intValue()) < i) {
                        world.setBlockAndUpdate((BlockPos)mut, (BlockState)((BlockState)state2.setValue((Property)SIZE, (Comparable)Integer.valueOf(i))).setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(true)));
                        continue;
                    }
                    break block6;
                }
                break block6;
            }
            if (!hasUp) break block6;
            mut.setX(pos.getX());
            mut.setZ(pos.getZ());
            for (int i = 1; i < 8; ++i) {
                BlockState state2;
                int size;
                mut.setY(pos.getY() + i);
                if (this.isThis((LevelReader)world, (BlockPos)mut) && (size = ((Integer)(state2 = world.getBlockState((BlockPos)mut)).getValue((Property)SIZE)).intValue()) < i) {
                    world.setBlockAndUpdate((BlockPos)mut, (BlockState)((BlockState)state2.setValue((Property)SIZE, (Comparable)Integer.valueOf(i))).setValue((Property)IS_FLOOR, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                break;
            }
        }
    }

    private boolean isThis(LevelReader world, BlockPos pos) {
        return this.isThis(world.getBlockState(pos));
    }

    private boolean isThis(BlockState state) {
        return state.getBlock() instanceof StalactiteBlock;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        int size = (Integer)state.getValue((Property)SIZE);
        return this.checkUp((BlockGetter)world, pos, size) || this.checkDown((BlockGetter)world, pos, size);
    }

    private boolean checkUp(BlockGetter world, BlockPos pos, int size) {
        BlockPos p = pos.above();
        BlockState state = world.getBlockState(p);
        return this.isThis(state) && (Integer)state.getValue((Property)SIZE) >= size || state.isCollisionShapeFullBlock(world, p);
    }

    private boolean checkDown(BlockGetter world, BlockPos pos, int size) {
        BlockPos p = pos.below();
        BlockState state = world.getBlockState(p);
        return this.isThis(state) && (Integer)state.getValue((Property)SIZE) >= size || state.isCollisionShapeFullBlock(world, p);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        ResourceLocation id = TextureMapping.getBlockTexture((Block)this);
        PropertyDispatch.C2 props = PropertyDispatch.properties((Property)IS_FLOOR, (Property)SIZE);
        for (int size = 0; size <= 7; ++size) {
            String suffix = "_" + size;
            TextureMapping mapping = new TextureMapping().put(TextureSlot.CROSS, id.withSuffix(suffix));
            ResourceLocation model = BCLModels.CROSS_SHADED.createWithSuffix((Block)this, suffix, mapping, generator.modelOutput());
            props.select((Comparable)Boolean.valueOf(true), (Comparable)Integer.valueOf(size), Variant.variant().with(VariantProperties.MODEL, (Object)model));
            props.select((Comparable)Boolean.valueOf(false), (Comparable)Integer.valueOf(size), Variant.variant().with(VariantProperties.MODEL, (Object)model).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180));
        }
        generator.acceptBlockState((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)this).with((PropertyDispatch)props));
        generator.createFlatItem((Block)this, TextureMapping.getItemTexture((Item)this.asItem()));
    }

    public boolean canPlaceLiquid(Player player, BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    static {
        float end = 0.25f;
        float start = 0.625f;
        SHAPES = new VoxelShape[8];
        for (int i = 0; i < 8; ++i) {
            int side = Mth.floor((float)(Mth.lerp((float)((float)i / 7.0f), (float)start, (float)end) * 8.0f + 0.5f));
            StalactiteBlock.SHAPES[i] = StalactiteBlock.box((double)side, (double)0.0, (double)side, (double)(16 - side), (double)16.0, (double)(16 - side));
        }
    }

    public static class Stone
    extends StalactiteBlock
    implements BehaviourStone {
        public Stone(Block source) {
            super(source);
        }

        public Stone(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }
}

