/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.blocks.UnderwaterPlantBlock;

public abstract class UnderwaterPlantWithAgeBlock
extends UnderwaterPlantBlock {
    public static final IntegerProperty AGE = BlockProperties.AGE;

    public UnderwaterPlantWithAgeBlock(BlockBehaviour.Properties properties) {
        super(properties.randomTicks());
    }

    public UnderwaterPlantWithAgeBlock() {
        this(BehaviourBuilders.createWaterPlant().sound(SoundType.WET_GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{AGE});
    }

    public abstract void grow(WorldGenLevel var1, RandomSource var2, BlockPos var3);

    @Override
    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (random.nextInt(4) == 0) {
            int age = (Integer)state.getValue((Property)AGE);
            if (age < 3) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
            } else {
                this.grow((WorldGenLevel)world, random, pos);
            }
        }
    }

    @Override
    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(state, world, pos, random);
        if (this.isBonemealSuccess((Level)world, random, pos, state)) {
            this.performBonemeal(world, random, pos, state);
        }
    }
}

