/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks.signs;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourExplosionResistant;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blocks.signs.BaseWallSignBlock;
import org.betterx.bclib.complexmaterials.BCLWoodTypeWrapper;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.CustomBlockItemProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public abstract class BaseSignBlock
extends StandingSignBlock
implements BlockModelProvider,
CustomBlockItemProvider,
BlockTagProvider,
ItemTagProvider,
DropSelfLootProvider<BaseSignBlock>,
BehaviourExplosionResistant {
    protected final Supplier<BaseWallSignBlock> wallSign;
    private BlockItem customItem;
    private BaseWallSignBlock wallSignBlock;
    private final Block parent;

    protected BaseSignBlock(Block parent, WoodType type, MapColor color, boolean flammable, WallSignProvider provider) {
        super(type, BehaviourBuilders.createSign(color, flammable));
        this.parent = parent;
        this.wallSign = () -> provider.create(BehaviourBuilders.createWallSign(color, (Block)this, flammable), type);
    }

    public BaseWallSignBlock getWallSignBlock() {
        if (this.wallSignBlock == null) {
            this.wallSignBlock = this.wallSign.get();
        }
        return this.wallSignBlock;
    }

    public float getYRotationDegrees(BlockState blockState) {
        return RotationSegment.convertToDegrees((int)((Integer)blockState.getValue((Property)StandingSignBlock.ROTATION)));
    }

    public BlockItem getCustomBlockItem(ResourceLocation blockID, Item.Properties settings) {
        if (this.customItem == null) {
            this.customItem = new SignItem(settings, (Block)this, (Block)this.getWallSignBlock());
        }
        return this.customItem;
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add((Object)this, new TagKey[]{BlockTags.STANDING_SIGNS});
    }

    public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
        context.add((ItemLike)this, new TagKey[]{ItemTags.SIGNS});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        BaseWallSignBlock wallSignBlock = this.getWallSignBlock();
        generator.createSign(this.parent, (Block)this, (Block)wallSignBlock);
    }

    public static BaseSignBlock from(Block parent, BCLWoodTypeWrapper type) {
        return new Wood(parent, type);
    }

    @FunctionalInterface
    public static interface WallSignProvider {
        public BaseWallSignBlock create(BlockBehaviour.Properties var1, WoodType var2);
    }

    public static class Wood
    extends BaseSignBlock
    implements BehaviourWood {
        public Wood(Block parent, WoodType type) {
            this(parent, type, MapColor.WOOD, true);
        }

        public Wood(Block parent, BCLWoodTypeWrapper type) {
            this(parent, type.type, type.color, type.flammable);
        }

        public Wood(Block parent, WoodType type, MapColor color, boolean flammable) {
            super(parent, type, color, flammable, BaseWallSignBlock.Wood::new);
        }
    }
}

