/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.screens;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.Button;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.client.gui.screens.BCLibLayoutScreen;

@OnlyIn(value=Dist.CLIENT)
public class LevelFixErrorScreen
extends BCLibLayoutScreen {
    private final String[] errors;
    final Listener onContinue;

    public LevelFixErrorScreen(Screen parent, String[] errors, Listener onContinue) {
        super(parent, (Component)Component.translatable((String)"title.bclib.datafixer.error"), 10, 10, 10);
        this.errors = errors;
        this.onContinue = onContinue;
    }

    protected LayoutComponent<?, ?> initContent() {
        VerticalStack grid = new VerticalStack(LevelFixErrorScreen.fill(), LevelFixErrorScreen.fill());
        grid.addSpacer(4);
        grid.addMultilineText(LevelFixErrorScreen.fill(), LevelFixErrorScreen.fit(), (Component)Component.translatable((String)"message.bclib.datafixer.error")).centerHorizontal();
        grid.addSpacer(8);
        HorizontalStack row = new HorizontalStack(LevelFixErrorScreen.fill(), LevelFixErrorScreen.fit());
        row.addSpacer(10);
        VerticalStack col = row.addColumn(LevelFixErrorScreen.fixed((int)300), LevelFixErrorScreen.fit());
        grid.addScrollable((LayoutComponent)row);
        for (String error : this.errors) {
            MutableComponent dash = Component.literal((String)"-");
            row = col.addRow();
            row.addText(LevelFixErrorScreen.fit(), LevelFixErrorScreen.fit(), (Component)dash);
            row.addSpacer(4);
            row.addText(LevelFixErrorScreen.fit(), LevelFixErrorScreen.fit(), (Component)Component.literal((String)error)).setColor(ColorHelper.RED);
        }
        grid.addSpacer(8);
        row = (HorizontalStack)grid.addRow().centerHorizontal();
        ((Button)row.addButton(LevelFixErrorScreen.fit(), LevelFixErrorScreen.fit(), (Component)Component.translatable((String)"title.bclib.datafixer.error.continue")).setAlpha(0.5f)).onPress(n -> {
            this.onClose();
            this.onContinue.doContinue(true);
        });
        row.addSpacer(4);
        row.addButton(LevelFixErrorScreen.fit(), LevelFixErrorScreen.fit(), CommonComponents.GUI_CANCEL).onPress(n -> this.minecraft.setScreen(null));
        return grid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface Listener {
        public void doContinue(boolean var1);
    }
}

