/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.models;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class UnbakedQuad {
    private static final Vector4f POS = new Vector4f();
    private final float[] data = new float[20];
    private Direction dir = Direction.UP;
    private boolean useShading = false;
    private int spriteIndex;

    public void addData(int index, float value) {
        this.data[index] = value;
    }

    public void setSpriteIndex(int index) {
        this.spriteIndex = index;
    }

    public void setDirection(Direction dir) {
        this.dir = dir;
    }

    public void setShading(boolean useShading) {
        this.useShading = useShading;
    }

    public Vector3f getPos(int index, Vector3f result) {
        int dataIndex = index * 5;
        float x = this.data[dataIndex++];
        float y = this.data[dataIndex++];
        float z = this.data[dataIndex];
        result.set(x, y, z);
        return result;
    }

    public BakedQuad bake(TextureAtlasSprite[] sprites, ModelState modelState) {
        Matrix4f matrix = modelState.getRotation().getMatrix();
        TextureAtlasSprite sprite = sprites[this.spriteIndex];
        int[] vertexData = new int[32];
        for (int i = 0; i < 4; ++i) {
            int index = i << 3;
            int dataIndex = i * 5;
            float x = this.data[dataIndex++];
            float y = this.data[dataIndex++];
            float z = this.data[dataIndex++];
            POS.set(x, y, z, 0.0f);
            POS.mul((Matrix4fc)matrix);
            vertexData[index] = Float.floatToIntBits(POS.x());
            vertexData[index | 1] = Float.floatToIntBits(POS.y());
            vertexData[index | 2] = Float.floatToIntBits(POS.z());
            vertexData[index | 3] = -1;
            vertexData[index | 4] = Float.floatToIntBits(sprite.getU(this.data[dataIndex++]));
            vertexData[index | 5] = Float.floatToIntBits(sprite.getV(this.data[dataIndex]));
        }
        return new BakedQuad(vertexData, 0, this.dir, sprites[this.spriteIndex], this.useShading);
    }
}

