/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.HashMap;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.blockentities.BaseChestBlockEntity;
import org.betterx.bclib.client.models.BaseChestBlockModel;

@OnlyIn(value=Dist.CLIENT)
public class BaseChestBlockEntityRenderer
implements BlockEntityRenderer<BaseChestBlockEntity> {
    private static final HashMap<Block, RenderType[]> LAYERS = Maps.newHashMap();
    private static final RenderType[] RENDER_TYPES = new RenderType[]{RenderType.entityCutout((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/entity/chest/normal.png")), RenderType.entityCutout((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/entity/chest/normal_left.png")), RenderType.entityCutout((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/entity/chest/normal_right.png"))};
    private static final int ID_NORMAL = 0;
    private static final int ID_LEFT = 1;
    private static final int ID_RIGHT = 2;
    private final BaseChestBlockModel chestModel = new BaseChestBlockModel(BaseChestBlockModel.getTexturedModelData().bakeRoot());

    public BaseChestBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(BaseChestBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.getLevel();
        boolean worldExists = world != null;
        BlockState blockState = worldExists ? entity.getBlockState() : (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        ChestType chestType = blockState.hasProperty((Property)ChestBlock.TYPE) ? (ChestType)blockState.getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
        Block block = blockState.getBlock();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractChestBlock = (AbstractChestBlock)block;
            boolean isDouble = chestType != ChestType.SINGLE;
            float f = ((Direction)blockState.getValue((Property)ChestBlock.FACING)).toYRot();
            matrices.pushPose();
            matrices.translate(0.5, 0.5, 0.5);
            matrices.mulPose(Axis.YP.rotationDegrees(-f));
            matrices.translate(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult propertySource = worldExists ? abstractChestBlock.combine(blockState, world, entity.getBlockPos(), true) : DoubleBlockCombiner.Combiner::acceptNone;
            float pitch = ((Float2FloatFunction)propertySource.apply(ChestBlock.opennessCombiner((LidBlockEntity)entity))).get(tickDelta);
            pitch = 1.0f - pitch;
            pitch = 1.0f - pitch * pitch * pitch;
            int blockLight = ((Int2IntFunction)propertySource.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(light);
            VertexConsumer vertexConsumer = BaseChestBlockEntityRenderer.getConsumer(vertexConsumers, block, chestType);
            if (isDouble) {
                if (chestType == ChestType.LEFT) {
                    this.renderParts(matrices, vertexConsumer, this.chestModel.partLeftA, this.chestModel.partLeftB, this.chestModel.partLeftC, pitch, blockLight, overlay);
                } else {
                    this.renderParts(matrices, vertexConsumer, this.chestModel.partRightA, this.chestModel.partRightB, this.chestModel.partRightC, pitch, blockLight, overlay);
                }
            } else {
                this.renderParts(matrices, vertexConsumer, this.chestModel.partA, this.chestModel.partB, this.chestModel.partC, pitch, blockLight, overlay);
            }
            matrices.popPose();
        }
    }

    private void renderParts(PoseStack matrices, VertexConsumer vertices, ModelPart modelPart, ModelPart modelPart2, ModelPart modelPart3, float pitch, int light, int overlay) {
        modelPart2.xRot = modelPart.xRot = -(pitch * 1.5707964f);
        modelPart.render(matrices, vertices, light, overlay);
        modelPart2.render(matrices, vertices, light, overlay);
        modelPart3.render(matrices, vertices, light, overlay);
    }

    private static RenderType getChestTexture(ChestType type, RenderType[] layers) {
        return switch (type) {
            case ChestType.LEFT -> layers[1];
            case ChestType.RIGHT -> layers[2];
            default -> layers[0];
        };
    }

    public static VertexConsumer getConsumer(MultiBufferSource provider, Block block, ChestType chestType) {
        RenderType[] layers = LAYERS.getOrDefault(block, RENDER_TYPES);
        return provider.getBuffer(BaseChestBlockEntityRenderer.getChestTexture(chestType, layers));
    }

    public static void registerRenderLayer(Block block) {
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        String modId = blockId.getNamespace();
        String path = blockId.getPath();
        LAYERS.put(block, new RenderType[]{RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)("textures/entity/chest/" + path + ".png"))), RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)("textures/entity/chest/" + path + "_left.png"))), RenderType.entityCutout((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)("textures/entity/chest/" + path + "_right.png")))});
    }
}

