/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.IdMapper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.mixin.common.IdMapperAccessor;

public class BlockStateDumpCommand {
    private static final int DEFAULT_SAMPLE = 10;
    private static final int MAX_SAMPLE = 200;
    private static final int MAX_DUMP_RANGE = 500;
    private static final String DEFAULT_PREFIX = "blockstate-dump-";
    private static final DateTimeFormatter FILE_TS = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
    private static final long FNV_OFFSET = -3750763034362895579L;
    private static final long FNV_PRIME = 1099511628211L;

    public static LiteralArgumentBuilder<CommandSourceStack> register(LiteralArgumentBuilder<CommandSourceStack> bnContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blockstate_dump").requires(source -> source.hasPermission(4))).executes(ctx -> BlockStateDumpCommand.dump((CommandContext<CommandSourceStack>)ctx, 10))).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)200)).executes(ctx -> BlockStateDumpCommand.dump((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"blockstate_dump_range").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"start", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)500)).executes(ctx -> BlockStateDumpCommand.dumpRange((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"start"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"blockstate_hash").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"start", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> BlockStateDumpCommand.hashRangeCommand((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"start"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"blockstate_dump_file").requires(source -> source.hasPermission(4))).executes(ctx -> BlockStateDumpCommand.dumpFile((CommandContext<CommandSourceStack>)ctx, null))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> BlockStateDumpCommand.dumpFile((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
    }

    private static int dump(CommandContext<CommandSourceStack> ctx, int sample) {
        int size = Block.BLOCK_STATE_REGISTRY.size();
        int canonicalMaxId = BlockStateDumpCommand.getCanonicalMaxId();
        int span = BlockStateDumpCommand.getSpan();
        int maxId = span > 0 ? span - 1 : -1;
        long hash = BlockStateDumpCommand.hashRange(0, span);
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.sendSuccess(() -> Component.literal((String)("BlockState registry size: " + size)), false);
        source.sendSuccess(() -> Component.literal((String)("BlockState registry canonical max id: " + canonicalMaxId)), false);
        source.sendSuccess(() -> Component.literal((String)("BlockState registry max id: " + maxId)), false);
        source.sendSuccess(() -> Component.literal((String)("BlockState registry span: " + span)), false);
        source.sendSuccess(() -> Component.literal((String)("BlockState registry hash: " + Long.toUnsignedString(hash, 16))), false);
        if (span == 0) {
            return 1;
        }
        int aliasCount = BlockStateDumpCommand.countAliasIds(span);
        if (aliasCount > 0) {
            source.sendSuccess(() -> Component.literal((String)("BlockState registry alias ids: " + aliasCount)), false);
        }
        int head = Math.min(sample, span);
        source.sendSuccess(() -> Component.literal((String)("First " + head + ":")), false);
        int i = 0;
        while (i < head) {
            int id = i++;
            BlockState state = Block.stateById((int)id);
            MutableComponent line = BlockStateDumpCommand.formatLine(id, state);
            source.sendSuccess(() -> line, false);
        }
        if (span > head) {
            int tailStart = Math.max(0, span - head);
            source.sendSuccess(() -> Component.literal((String)("Last " + head + ":")), false);
            int i2 = tailStart;
            while (i2 < span) {
                int id = i2++;
                BlockState state = Block.stateById((int)id);
                MutableComponent line = BlockStateDumpCommand.formatLine(id, state);
                source.sendSuccess(() -> line, false);
            }
        }
        return 1;
    }

    private static int dumpRange(CommandContext<CommandSourceStack> ctx, int start, int count) {
        int span = BlockStateDumpCommand.getSpan();
        int maxId = span > 0 ? span - 1 : -1;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (span == 0) {
            source.sendSuccess(() -> Component.literal((String)"BlockState registry size: 0"), false);
            return 1;
        }
        if (start >= span) {
            source.sendFailure((Component)Component.literal((String)("Start index " + start + " is out of range (max id " + maxId + ")")));
            return 0;
        }
        int end = Math.min(span, start + count);
        source.sendSuccess(() -> Component.literal((String)("Range " + start + ".." + (end - 1) + ":")), false);
        int i = start;
        while (i < end) {
            int id = i++;
            BlockState state = Block.stateById((int)id);
            MutableComponent line = BlockStateDumpCommand.formatLine(id, state);
            source.sendSuccess(() -> line, false);
        }
        return 1;
    }

    private static int hashRangeCommand(CommandContext<CommandSourceStack> ctx, int start, int count) {
        int span = BlockStateDumpCommand.getSpan();
        int maxId = span > 0 ? span - 1 : -1;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (span == 0) {
            source.sendSuccess(() -> Component.literal((String)"BlockState registry size: 0"), false);
            return 1;
        }
        if (start >= span) {
            source.sendFailure((Component)Component.literal((String)("Start index " + start + " is out of range (max id " + maxId + ")")));
            return 0;
        }
        int end = Math.min(span, start + count);
        long hash = BlockStateDumpCommand.hashRange(start, end);
        MutableComponent message = Component.literal((String)("BlockState hash " + start + ".." + (end - 1) + ": " + Long.toUnsignedString(hash, 16)));
        source.sendSuccess(() -> message, false);
        return 1;
    }

    private static int dumpFile(CommandContext<CommandSourceStack> ctx, String name) {
        int size = Block.BLOCK_STATE_REGISTRY.size();
        int canonicalMaxId = BlockStateDumpCommand.getCanonicalMaxId();
        int span = BlockStateDumpCommand.getSpan();
        int maxId = span > 0 ? span - 1 : -1;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        String filename = BlockStateDumpCommand.resolveDumpFilename(name);
        Path outDir = Paths.get("bclib", new String[0]);
        Path outFile = outDir.resolve(filename);
        try {
            Files.createDirectories(outDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            source.sendFailure((Component)Component.literal((String)("Failed to create output directory: " + String.valueOf(outDir))));
            return 0;
        }
        long hash = -3750763034362895579L;
        int aliasCount = 0;
        try (BufferedWriter writer = Files.newBufferedWriter(outFile, StandardCharsets.US_ASCII, new OpenOption[0]);){
            writer.write("# BlockState registry dump");
            writer.newLine();
            writer.write("# size: " + size);
            writer.newLine();
            writer.write("# canonical_max_id: " + canonicalMaxId);
            writer.newLine();
            writer.write("# max_id: " + maxId);
            writer.newLine();
            writer.write("# span: " + span);
            writer.newLine();
            for (int id = 0; id < span; ++id) {
                String stateText;
                BlockState state = Block.stateById((int)id);
                String string = stateText = state == null ? "null" : BlockStateDumpCommand.formatState(state);
                if (state != null && Block.BLOCK_STATE_REGISTRY.getId((Object)state) != id) {
                    ++aliasCount;
                }
                hash = BlockStateDumpCommand.fnv1a(hash, stateText);
                hash = BlockStateDumpCommand.fnv1a(hash, "\n");
                writer.write(id + "\t" + stateText);
                writer.newLine();
            }
            writer.write("# alias_ids: " + aliasCount);
            writer.newLine();
            writer.write("# hash: " + Long.toUnsignedString(hash, 16));
            writer.newLine();
        }
        catch (IOException e) {
            source.sendFailure((Component)Component.literal((String)("Failed to write dump: " + String.valueOf(outFile))));
            return 0;
        }
        String resultPath = outDir.resolve(filename).toString();
        source.sendSuccess(() -> Component.literal((String)("Wrote blockstate dump to " + resultPath)), false);
        return 1;
    }

    private static MutableComponent formatLine(int id, BlockState state) {
        String display = state == null ? "null" : BlockStateDumpCommand.formatState(state);
        MutableComponent result = Component.literal((String)(id + ": ")).setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE));
        result.append((Component)Component.literal((String)display).setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE)));
        return result;
    }

    private static String formatState(BlockState state) {
        String blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
        ArrayList<Property> props = new ArrayList<Property>(state.getProperties());
        if (props.isEmpty()) {
            return blockId;
        }
        props.sort(Comparator.comparing(Property::getName));
        StringBuilder sb = new StringBuilder();
        for (Property property : props) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(property.getName()).append("=").append(state.getValue(property));
        }
        return blockId + "[" + String.valueOf(sb) + "]";
    }

    private static long hashRange(int start, int end) {
        long hash = -3750763034362895579L;
        for (int id = start; id < end; ++id) {
            BlockState state = Block.stateById((int)id);
            hash = BlockStateDumpCommand.fnv1a(hash, state == null ? "null" : BlockStateDumpCommand.formatState(state));
            hash = BlockStateDumpCommand.fnv1a(hash, "\n");
        }
        return hash;
    }

    private static int getMaxId() {
        int maxId = -1;
        for (BlockState state : Block.BLOCK_STATE_REGISTRY) {
            int id = Block.BLOCK_STATE_REGISTRY.getId((Object)state);
            if (id <= maxId) continue;
            maxId = id;
        }
        return maxId;
    }

    private static int getCanonicalMaxId() {
        return BlockStateDumpCommand.getMaxId();
    }

    private static int getSpan() {
        IdMapper idMapper = Block.BLOCK_STATE_REGISTRY;
        if (idMapper instanceof IdMapperAccessor) {
            IdMapperAccessor accessor = (IdMapperAccessor)idMapper;
            return accessor.bclib_getIdToT().size();
        }
        int maxId = BlockStateDumpCommand.getCanonicalMaxId();
        return maxId >= 0 ? maxId + 1 : 0;
    }

    private static int countAliasIds(int span) {
        int count = 0;
        for (int id = 0; id < span; ++id) {
            BlockState state = Block.stateById((int)id);
            if (state == null || Block.BLOCK_STATE_REGISTRY.getId((Object)state) == id) continue;
            ++count;
        }
        return count;
    }

    private static String resolveDumpFilename(String name) {
        if (name == null || name.isBlank()) {
            return DEFAULT_PREFIX + LocalDateTime.now().format(FILE_TS) + ".txt";
        }
        Object trimmed = name.trim();
        if (!((String)trimmed).endsWith(".txt")) {
            trimmed = (String)trimmed + ".txt";
        }
        return trimmed;
    }

    private static long fnv1a(long hash, String value) {
        for (int i = 0; i < value.length(); ++i) {
            hash ^= (long)value.charAt(i);
            hash *= 1099511628211L;
        }
        return hash;
    }
}

