/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.betterx.bclib.commands.BlockStateDumpCommand;
import org.betterx.bclib.commands.BlockStateIdCommand;
import org.betterx.bclib.commands.DumpMap;
import org.betterx.bclib.commands.PlaceCommand;
import org.betterx.bclib.commands.PrintInfo;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class CommandRegistry {
    private static final Map<Holder<Biome>, BlockState> biomeMap = new HashMap<Holder<Biome>, BlockState>();
    private static int biomeMapIdx = 0;
    private static final BlockState[] states = new BlockState[]{Blocks.RED_STAINED_GLASS.defaultBlockState(), Blocks.BLUE_STAINED_GLASS.defaultBlockState(), Blocks.YELLOW_STAINED_GLASS.defaultBlockState(), Blocks.LIME_STAINED_GLASS.defaultBlockState(), Blocks.PINK_STAINED_GLASS.defaultBlockState(), Blocks.GREEN_STAINED_GLASS.defaultBlockState(), Blocks.WHITE_STAINED_GLASS.defaultBlockState(), Blocks.BLACK_STAINED_GLASS.defaultBlockState(), Blocks.ORANGE_STAINED_GLASS.defaultBlockState(), Blocks.LIGHT_BLUE_STAINED_GLASS.defaultBlockState()};
    private static final BlockState[] states2 = new BlockState[]{Blocks.RED_CONCRETE.defaultBlockState(), Blocks.BLUE_CONCRETE.defaultBlockState(), Blocks.YELLOW_CONCRETE.defaultBlockState(), Blocks.LIME_CONCRETE.defaultBlockState(), Blocks.PINK_CONCRETE.defaultBlockState(), Blocks.GREEN_CONCRETE.defaultBlockState(), Blocks.WHITE_CONCRETE.defaultBlockState(), Blocks.BLACK_CONCRETE.defaultBlockState(), Blocks.ORANGE_CONCRETE.defaultBlockState(), Blocks.LIGHT_BLUE_CONCRETE.defaultBlockState()};

    public static void register() {
        NeoForge.EVENT_BUS.addListener(CommandRegistry::onRegisterCommands);
    }

    private static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandRegistry.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        LiteralArgumentBuilder<CommandSourceStack> bnContext = (LiteralArgumentBuilder<CommandSourceStack>)Commands.literal((String)"bclib").requires(source -> source.hasPermission(4));
        bnContext = PlaceCommand.register(bnContext, commandBuildContext);
        bnContext = PrintInfo.register(bnContext);
        bnContext = DumpMap.register(bnContext);
        bnContext = BlockStateIdCommand.register(bnContext);
        bnContext = BlockStateDumpCommand.register(bnContext);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)Commands.literal((String)"request_garbage_collection").requires(source -> source.hasPermission(4))).executes(CommandRegistry::requestGC))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug_ore").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"rings", (ArgumentType)IntegerArgumentType.integer((int)0, (int)8)).executes(ctx -> CommandRegistry.revealOre((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"rings"))))).executes(cc -> CommandRegistry.revealOre((CommandContext<CommandSourceStack>)cc, 0)))).then(((LiteralArgumentBuilder)Commands.literal((String)"sliceZ").requires(source -> source.hasPermission(4))).executes(ctx -> CommandRegistry.slice((CommandContext<CommandSourceStack>)ctx, true)))).then(((LiteralArgumentBuilder)Commands.literal((String)"sliceX").requires(source -> source.hasPermission(4))).executes(ctx -> CommandRegistry.slice((CommandContext<CommandSourceStack>)ctx, false))));
    }

    private static int requestGC(CommandContext<CommandSourceStack> ctx) {
        System.gc();
        return 1;
    }

    private static int revealOre(CommandContext<CommandSourceStack> ctx, int chunks) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel level = source.getLevel();
        Vec3 spos = source.getPosition();
        BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos();
        BlockState AIR = Blocks.AIR.defaultBlockState();
        for (int ox = -chunks; ox <= chunks; ++ox) {
            for (int oz = -chunks; oz <= chunks; ++oz) {
                Vec3 pos = new Vec3(spos.x + (double)(ox * 64), spos.y, spos.z + (double)(oz * 64));
                source.getPlayer().teleportTo(pos.x, pos.y, pos.z);
                for (int y = 1; y < level.getHeight(); ++y) {
                    bp.setY(y);
                    for (int x = -64; x < 64; ++x) {
                        bp.setX((int)pos.x + x);
                        for (int z = -64; z < 64; ++z) {
                            BlockState fillState;
                            bp.setZ((int)pos.z + z);
                            if (y == 1) {
                                Holder b = level.getBiome((BlockPos)bp);
                                fillState = biomeMap.computeIfAbsent((Holder<Biome>)b, bb -> {
                                    biomeMapIdx = (biomeMapIdx + 1) % states.length;
                                    return states[biomeMapIdx];
                                });
                            } else {
                                fillState = AIR;
                            }
                            BlockState state = level.getBlockState((BlockPos)bp);
                            if (y != 1 && state.is(Blocks.AIR) || state.is(CommonBlockTags.NETHER_ORES) || state.is(CommonBlockTags.END_ORES) || state.is(BlockTags.COAL_ORES) || state.is(BlockTags.COPPER_ORES) || state.is(BlockTags.DIAMOND_ORES) || state.is(BlockTags.EMERALD_ORES) || state.is(BlockTags.GOLD_ORES) || state.is(BlockTags.IRON_ORES) || state.is(BlockTags.LAPIS_ORES) || state.is(BlockTags.REDSTONE_ORES) || state.is(Blocks.NETHER_QUARTZ_ORE) || state.is(Blocks.NETHER_GOLD_ORE) || state.is(Blocks.ANCIENT_DEBRIS)) continue;
                            BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)bp, fillState);
                        }
                    }
                }
            }
        }
        source.getPlayer().teleportTo(spos.x, spos.y, spos.z);
        return 1;
    }

    private static int slice(CommandContext<CommandSourceStack> ctx, boolean constX) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel level = source.getLevel();
        Vec3 pos = source.getPosition();
        BlockState AIR = Blocks.AIR.defaultBlockState();
        BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos();
        for (int y = 1; y < level.getHeight(); ++y) {
            int x;
            bp.setY(y);
            int n = x = constX ? 0 : -64;
            while (x < 64) {
                int z;
                bp.setX((int)pos.x + x);
                int n2 = z = constX ? -64 : 0;
                while (z < 64) {
                    BlockState fillState;
                    bp.setZ((int)pos.z + z);
                    if (y == 1) {
                        Holder b = level.getBiome((BlockPos)bp);
                        fillState = biomeMap.computeIfAbsent((Holder<Biome>)b, bb -> {
                            biomeMapIdx = (biomeMapIdx + 1) % states.length;
                            return states[biomeMapIdx];
                        });
                    } else {
                        fillState = AIR;
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)bp, fillState);
                    ++z;
                }
                ++x;
            }
        }
        return 1;
    }

    private static int findSurface(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.getPlayerOrException();
        Vec3 pos = source.getPosition();
        ServerLevel level = source.getLevel();
        BlockPos.MutableBlockPos mPos = new BlockPos((int)pos.x, (int)pos.y, (int)pos.z).mutable();
        System.out.println("Staring at: " + String.valueOf(mPos) + " -> " + String.valueOf(level.getBlockState((BlockPos)mPos)));
        boolean found = BlocksHelper.findSurroundingSurface((LevelAccessor)level, mPos, Direction.DOWN, 12, state -> BlocksHelper.isTerrain(state));
        System.out.println("Ending at: " + String.valueOf(mPos) + " -> " + String.valueOf(level.getBlockState((BlockPos)mPos)) + " = " + found);
        BlocksHelper.setWithoutUpdate((LevelAccessor)level, new BlockPos((int)pos.x, (int)pos.y, (int)pos.z), Blocks.YELLOW_CONCRETE);
        BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)mPos, Blocks.LIGHT_BLUE_CONCRETE);
        return 1;
    }
}

