/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials.entry;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.complexmaterials.ComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.BlockEntry;
import org.betterx.bclib.complexmaterials.entry.SimpleMaterialSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleBlockOnlyMaterialSlot<M extends ComplexMaterial>
extends SimpleMaterialSlot<M> {
    public SimpleBlockOnlyMaterialSlot(@NotNull String suffix) {
        super(suffix);
    }

    @Override
    @Nullable
    protected BlockEntry getBlockEntry(M parentMaterial) {
        BlockEntry entry = new BlockEntry(this.suffix, false, (c, p) -> this.createBlock(parentMaterial, (BlockBehaviour.Properties)p));
        this.modifyBlockEntry(parentMaterial, entry);
        return entry;
    }

    public static <M extends ComplexMaterial> SimpleBlockOnlyMaterialSlot<M> createBlockOnly(@NotNull String suffix, final BiFunction<ComplexMaterial, BlockBehaviour.Properties, Block> maker) {
        return new SimpleBlockOnlyMaterialSlot(suffix){

            @Override
            @NotNull
            protected Block createBlock(ComplexMaterial parentMaterial, BlockBehaviour.Properties settings) {
                return (Block)maker.apply(parentMaterial, settings);
            }

            @Override
            @Nullable
            protected void makeRecipe(RecipeOutput context, ComplexMaterial parentMaterial, ResourceLocation id) {
            }
        };
    }

    public static <M extends ComplexMaterial> SimpleBlockOnlyMaterialSlot<M> createBlockOnly(@NotNull String suffix, final Supplier<Block> maker) {
        return new SimpleBlockOnlyMaterialSlot(suffix){

            @Override
            @NotNull
            protected Block createBlock(ComplexMaterial parentMaterial, BlockBehaviour.Properties settings) {
                return (Block)maker.get();
            }

            @Override
            @Nullable
            protected void makeRecipe(RecipeOutput context, ComplexMaterial parentMaterial, ResourceLocation id) {
            }
        };
    }
}

