/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.furniture.block;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.furniture.block.BaseChair;
import org.betterx.bclib.furniture.entity.EntityChair;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.loot.api.BlockLootProvider;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChair
extends BaseBlockNotFull
implements BlockModelProvider,
BlockLootProvider {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public final Block baseMaterial;
    protected final float height;

    public static BlockBehaviour.Properties defaultFurnitureProperties(Block block) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block).noOcclusion();
    }

    public AbstractChair(Block baseMaterial, int height) {
        super(AbstractChair.defaultFurnitureProperties(baseMaterial));
        this.height = ((float)height - 3.0f) / 16.0f;
        this.baseMaterial = baseMaterial;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        EntityChair entity;
        if (world.isClientSide) {
            return ItemInteractionResult.FAIL;
        }
        if (player.isPassenger() || player.isSpectator()) {
            return ItemInteractionResult.FAIL;
        }
        Optional<EntityChair> active = this.getEntity(world, pos);
        if (active.isEmpty()) {
            entity = this.createEntity(state, world, pos);
        } else {
            entity = active.get();
            if (entity.isVehicle()) {
                return ItemInteractionResult.FAIL;
            }
        }
        if (entity != null) {
            float yaw = ((Direction)state.getValue((Property)FACING)).getOpposite().toYRot();
            player.startRiding((Entity)entity, true);
            player.setYBodyRot(yaw);
            player.setYHeadRot(yaw);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    @Nullable
    private EntityChair createEntity(BlockState state, Level world, BlockPos pos) {
        BCLib.LOGGER.info("Creating Chair at " + String.valueOf(pos) + ", " + String.valueOf(state));
        double px = (double)pos.getX() + 0.5;
        double py = (float)pos.getY() + this.height;
        double pz = (double)pos.getZ() + 0.5;
        float yaw = ((Direction)state.getValue((Property)FACING)).getOpposite().toYRot();
        EntityChair entity = (EntityChair)BaseBlockEntities.CHAIR.create(world);
        entity.moveTo(px, py, pz, yaw, 0.0f);
        entity.setNoGravity(true);
        entity.setSilent(true);
        entity.setInvisible(true);
        entity.setYHeadRot(yaw);
        entity.setYBodyRot(yaw);
        if (!world.addFreshEntity((Entity)entity)) {
            entity = null;
        }
        return entity;
    }

    private Optional<EntityChair> getEntity(Level level, BlockPos pos) {
        List list = level.getEntitiesOfClass(EntityChair.class, new AABB(pos), entity -> true);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((EntityChair)((Object)list.get(0)));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        super.onPlace(blockState, level, blockPos, blockState2, bl);
        BCLib.LOGGER.info("Created at " + String.valueOf(blockPos) + ", " + String.valueOf(blockState) + ", " + String.valueOf(blockState2));
        if (blockState.hasProperty((Property)BaseChair.TOP) && ((Boolean)blockState.getValue((Property)BaseChair.TOP)).booleanValue()) {
            return;
        }
        this.createEntity(blockState, level, blockPos);
    }

    @Override
    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        return provider.drop((ItemLike)this.asItem());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
    }
}

