/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.furniture.block;

import java.util.Objects;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BCLModels;
import org.betterx.bclib.furniture.block.AbstractChair;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.loot.api.LootLookupProvider;
import org.jetbrains.annotations.NotNull;

public abstract class BaseChair
extends AbstractChair {
    private static final VoxelShape SHAPE_BOTTOM = BaseChair.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_TOP = BaseChair.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
    private static final VoxelShape COLLIDER = BaseChair.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public final Block clothMaterial;

    public BaseChair(Block baseMaterial, Block clothMaterial) {
        super(baseMaterial, 10);
        this.clothMaterial = Objects.requireNonNull(clothMaterial, "Chair cloth material cannot be null (" + baseMaterial.getDescriptionId() + ")");
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Deprecated(forRemoval=true)
    public BaseChair(Block baseMaterial) {
        this(baseMaterial, Blocks.RED_WOOL);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING, TOP});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return (Boolean)state.getValue((Property)TOP) != false ? SHAPE_TOP : SHAPE_BOTTOM;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return (Boolean)state.getValue((Property)TOP) != false ? Shapes.empty() : COLLIDER;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return true;
        }
        BlockState up = world.getBlockState(pos.above());
        return up.isAir() || up.getBlock() == this && (Boolean)up.getValue((Property)TOP) != false;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide()) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, pos.above(), (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(true)));
        }
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            return world.getBlockState(pos.below()).getBlock() == this ? state : Blocks.AIR.defaultBlockState();
        }
        return world.getBlockState(pos.above()).getBlock() == this ? state : Blocks.AIR.defaultBlockState();
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (((Boolean)state.getValue((Property)TOP)).booleanValue()) {
            pos = pos.below();
            state = world.getBlockState(pos);
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    @NotNull
    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (player.isCreative() && ((Boolean)state.getValue((Property)TOP)).booleanValue() && world.getBlockState(pos.below()).getBlock() == this) {
            world.setBlockAndUpdate(pos.below(), Blocks.AIR.defaultBlockState());
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Deprecated(forRemoval=true)
    public static BaseChair from(Block source) {
        return BehaviourHelper.from(source, Wood::new, Stone::new, Metal::new);
    }

    public static BaseChair from(Block baseMaterial, Block clothMaterial) {
        return BehaviourHelper.from(baseMaterial, b -> new Wood((Block)b, clothMaterial), b -> new Stone((Block)b, clothMaterial), b -> new Metal((Block)b, clothMaterial));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        BCLModels.createChairBlockModel(generator, this, this.baseMaterial, this.clothMaterial);
    }

    @Override
    public LootTable.Builder registerBlockLoot(@NotNull ResourceLocation location, @NotNull LootLookupProvider provider, @NotNull ResourceKey<LootTable> tableKey) {
        LootItemBlockStatePropertyCondition.Builder bottomShape = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)this).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)TOP, false));
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)this.asItem())).when((LootItemCondition.Builder)bottomShape));
    }

    public static class Metal
    extends BaseChair
    implements BehaviourMetal {
        @Deprecated(forRemoval=true)
        public Metal(Block baseMaterial) {
            super(baseMaterial, Blocks.RED_WOOL);
        }

        public Metal(Block baseMaterial, Block clothMaterial) {
            super(baseMaterial, clothMaterial);
        }
    }

    public static class Stone
    extends BaseChair
    implements BehaviourStone {
        @Deprecated(forRemoval=true)
        public Stone(Block baseMaterial) {
            super(baseMaterial, Blocks.RED_WOOL);
        }

        public Stone(Block baseMaterial, Block clothMaterial) {
            super(baseMaterial, clothMaterial);
        }
    }

    public static class Wood
    extends BaseChair
    implements BehaviourWood {
        @Deprecated(forRemoval=true)
        public Wood(Block baseMaterial) {
            super(baseMaterial, Blocks.RED_WOOL);
        }

        public Wood(Block baseMaterial, Block clothMaterial) {
            super(baseMaterial, clothMaterial);
        }
    }
}

