/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.furniture.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BCLModels;
import org.betterx.bclib.furniture.block.AbstractChair;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.jetbrains.annotations.NotNull;

public abstract class BaseTaburet
extends AbstractChair {
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);

    public BaseTaburet(Block block) {
        super(block, 9);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public static BaseTaburet from(Block source) {
        return BehaviourHelper.from(source, Wood::new, Stone::new, Metal::new);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        BCLModels.createTaburetBlockModel(generator, this, this.baseMaterial);
    }

    public static class Metal
    extends BaseTaburet
    implements BehaviourMetal {
        public Metal(Block block) {
            super(block);
        }
    }

    public static class Stone
    extends BaseTaburet
    implements BehaviourStone {
        public Stone(Block block) {
            super(block);
        }
    }

    public static class Wood
    extends BaseTaburet
    implements BehaviourWood {
        public Wood(Block block) {
            super(block);
        }
    }
}

