/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.common;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.betterx.bclib.recipes.BCLRecipeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeManager.class})
public abstract class RecipeManagerMixin {
    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    public void bcl_interceptApply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler, CallbackInfo info) {
        BCLRecipeManager.removeDisabledRecipes(resourceManager, map);
    }

    @Shadow
    protected abstract <I extends RecipeInput, T extends Recipe<I>> Collection<RecipeHolder<T>> byType(RecipeType<T> var1);

    @Inject(method={"getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeType;Lnet/minecraft/world/item/crafting/RecipeInput;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;"}, at={@At(value="HEAD")}, cancellable=true)
    <I extends RecipeInput, T extends Recipe<I>> void bcl_sort(RecipeType<T> recipeType, I recipeInput, Level level, CallbackInfoReturnable<Optional<RecipeHolder<T>>> cir) {
        Collection<RecipeHolder<T>> inter = this.byType(recipeType);
        List<RecipeHolder> all = inter.stream().filter(recipe -> recipe.value().matches(recipeInput, level)).sorted((a, b) -> {
            if (a.id().getNamespace().equals(b.id().getNamespace())) {
                return a.id().getPath().compareTo(b.id().getPath());
            }
            if (a.id().getNamespace().equals("minecraft") && !b.id().getNamespace().equals("minecraft")) {
                return 1;
            }
            if (!a.id().getNamespace().equals("minecraft") && b.id().getNamespace().equals("minecraft")) {
                return -1;
            }
            return a.id().getNamespace().compareTo(b.id().getNamespace());
        }).toList();
        if (all.size() > 1) {
            cir.setReturnValue(Optional.of(all.get(0)));
        }
    }
}

