/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.mixin.common.shears;

import java.util.Optional;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import org.betterx.wover.tag.api.predefined.CommonItemTags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MatchTool.class})
public class MatchToolMixin {
    @Unique
    private boolean bcl_isShears;
    @Unique
    private static final ItemPredicate BCL_SHEARS_PREDICATE = ItemPredicate.Builder.item().of(CommonItemTags.SHEARS).build();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void bcl_initShears(Optional<ItemPredicate> optional, CallbackInfo ci) {
        HolderSet items;
        if (optional.isPresent() && optional.get().items().isPresent() && (items = (HolderSet)optional.get().items().get()).size() == 1 && items.get(0).value() == Items.SHEARS) {
            this.bcl_isShears = true;
        }
    }

    @Inject(method={"test(Lnet/minecraft/world/level/storage/loot/LootContext;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void bcl_isShears(LootContext lootContext, CallbackInfoReturnable<Boolean> cir) {
        if (this.bcl_isShears) {
            ItemStack itemStack = (ItemStack)lootContext.getParamOrNull(LootContextParams.TOOL);
            cir.setReturnValue((Object)(itemStack != null && BCL_SHEARS_PREDICATE.test(itemStack) ? 1 : 0));
        }
    }
}

