/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.sdf.operator;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.util.Mth;
import org.betterx.bclib.sdf.operator.SDFDisplacement;

public class SDFHeightmap
extends SDFDisplacement {
    private float intensity = 1.0f;
    private NativeImage map;
    private float offsetX;
    private float offsetZ;
    private float scale;
    private float cos = 1.0f;
    private float sin = 0.0f;

    public SDFHeightmap() {
        this.setFunction(pos -> {
            if (this.map == null) {
                return Float.valueOf(0.0f);
            }
            float px = Mth.clamp((float)(pos.x() * this.scale + this.offsetX), (float)0.0f, (float)(this.map.getWidth() - 2));
            float pz = Mth.clamp((float)(pos.z() * this.scale + this.offsetZ), (float)0.0f, (float)(this.map.getHeight() - 2));
            float dx = px * this.cos - pz * this.sin;
            float dz = pz * this.cos + px * this.sin;
            int x1 = Mth.floor((float)dx);
            int z1 = Mth.floor((float)dz);
            int x2 = x1 + 1;
            int z2 = z1 + 1;
            dx -= (float)x1;
            dz -= (float)z1;
            float a = (float)(this.map.getPixelRGBA(x1, z1) & 0xFF) / 255.0f;
            float b = (float)(this.map.getPixelRGBA(x2, z1) & 0xFF) / 255.0f;
            float c = (float)(this.map.getPixelRGBA(x1, z2) & 0xFF) / 255.0f;
            float d = (float)(this.map.getPixelRGBA(x2, z2) & 0xFF) / 255.0f;
            a = Mth.lerp((float)dx, (float)a, (float)b);
            b = Mth.lerp((float)dx, (float)c, (float)d);
            return Float.valueOf(-Mth.lerp((float)dz, (float)a, (float)b) * this.intensity);
        });
    }

    public SDFHeightmap setMap(NativeImage map) {
        this.map = map;
        this.offsetX = (float)map.getWidth() * 0.5f;
        this.offsetZ = (float)map.getHeight() * 0.5f;
        this.scale = map.getWidth();
        return this;
    }

    public SDFHeightmap setAngle(float angle) {
        this.sin = Mth.sin((float)angle);
        this.cos = Mth.cos((float)angle);
        return this;
    }

    public SDFHeightmap setScale(float scale) {
        this.scale = (float)this.map.getWidth() * scale;
        return this;
    }

    public SDFHeightmap setIntensity(float intensity) {
        this.intensity = intensity;
        return this;
    }
}

