/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.level.material.PushReaction;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlantLike;
import org.betterx.wover.tag.api.predefined.CommonBlockTags;

public class BlocksHelper {
    private static final Map<Block, Integer> COLOR_BY_BLOCK = Maps.newHashMap();
    public static final int FLAG_UPDATE_BLOCK = 1;
    public static final int FLAG_SEND_CLIENT_CHANGES = 2;
    public static final int FLAG_NO_RERENDER = 4;
    public static final int FORSE_RERENDER = 8;
    public static final int FLAG_IGNORE_OBSERVERS = 16;
    public static final int SET_SILENT = 18;
    public static final int SET_OBSERV = 3;
    public static final Direction[] HORIZONTAL = BlocksHelper.makeHorizontal();
    public static final Direction[] DIRECTIONS = Direction.values();
    private static final ThreadLocal<BlockPos.MutableBlockPos> TL_POS = ThreadLocal.withInitial(() -> new BlockPos.MutableBlockPos());
    protected static final BlockState AIR = Blocks.AIR.defaultBlockState();
    protected static final BlockState WATER = Blocks.WATER.defaultBlockState();

    public static void addBlockColor(Block block, int color) {
        COLOR_BY_BLOCK.put(block, color);
    }

    public static int getBlockColor(Block block) {
        return COLOR_BY_BLOCK.getOrDefault(block, -16777216);
    }

    public static void setWithoutUpdate(LevelAccessor world, BlockPos pos, BlockState state) {
        world.setBlock(pos, state, 18);
    }

    public static void setWithoutUpdate(LevelAccessor world, BlockPos pos, Block block) {
        world.setBlock(pos, block.defaultBlockState(), 18);
    }

    public static void setWithUpdate(LevelAccessor world, BlockPos pos, BlockState state) {
        world.setBlock(pos, state, 3);
    }

    public static void setWithUpdate(LevelAccessor world, BlockPos pos, Block block) {
        world.setBlock(pos, block.defaultBlockState(), 3);
    }

    public static int upRay(LevelAccessor world, BlockPos pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.isEmptyBlock(pos.above(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRay(LevelAccessor world, BlockPos pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.isEmptyBlock(pos.below(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRayRep(LevelAccessor world, BlockPos pos, int maxDist) {
        BlockPos.MutableBlockPos POS = TL_POS.get();
        POS.set((Vec3i)pos);
        for (int j = 1; j < maxDist && world.getBlockState((BlockPos)POS).canBeReplaced(); ++j) {
            POS.setY(POS.getY() - 1);
        }
        return pos.getY() - POS.getY();
    }

    public static int raycastSqr(LevelAccessor world, BlockPos pos, int dx, int dy, int dz, int maxDist) {
        BlockPos.MutableBlockPos POS = TL_POS.get();
        POS.set((Vec3i)pos);
        for (int j = 1; j < maxDist && world.getBlockState((BlockPos)POS).canBeReplaced(); ++j) {
            POS.move(dx, dy, dz);
        }
        return (int)pos.distSqr((Vec3i)POS);
    }

    public static BlockState rotateHorizontal(BlockState state, Rotation rotation, Property<Direction> facing) {
        return (BlockState)state.setValue(facing, (Comparable)rotation.rotate((Direction)state.getValue(facing)));
    }

    public static BlockState mirrorHorizontal(BlockState state, Mirror mirror, Property<Direction> facing) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(facing)));
    }

    public static int getLengthDown(LevelAccessor world, BlockPos pos, Block block) {
        int count = 1;
        while (world.getBlockState(pos.below(count)).getBlock() == block) {
            ++count;
        }
        return count;
    }

    public static Direction[] makeHorizontal() {
        return new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    }

    public static Direction randomHorizontal(RandomSource random) {
        return HORIZONTAL[random.nextInt(4)];
    }

    public static Direction randomDirection(RandomSource random) {
        return DIRECTIONS[random.nextInt(6)];
    }

    public static boolean isInvulnerable(BlockState state, BlockGetter world, BlockPos pos) {
        return state.getDestroySpeed(world, pos) < 0.0f;
    }

    public static boolean isInvulnerableUnsafe(BlockState state) {
        try {
            return BlocksHelper.isInvulnerable(state, null, null);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Optional<BlockPos> findSurfaceBelow(LevelAccessor level, BlockPos startPos, int minY, Predicate<BlockState> surface) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos(startPos.getX(), startPos.getY(), startPos.getZ());
        for (int y = startPos.getY(); y >= minY; --y) {
            POS.setY(y);
            if (!surface.test(level.getBlockState((BlockPos)POS))) continue;
            return Optional.of(POS);
        }
        return Optional.empty();
    }

    public static boolean findSurface(LevelAccessor level, BlockPos.MutableBlockPos startPos, Direction dir, int length, Predicate<BlockState> surface) {
        for (int len = 0; len < length; ++len) {
            if (surface.test(level.getBlockState((BlockPos)startPos))) {
                return true;
            }
            startPos.move(dir, 1);
        }
        return false;
    }

    public static boolean findOnSurroundingSurface(LevelAccessor level, BlockPos.MutableBlockPos startPos, Direction dir, int length, Predicate<BlockState> surface) {
        for (int len = 0; len < length; ++len) {
            if (surface.test(level.getBlockState((BlockPos)startPos))) {
                if (len == 0) {
                    for (int lenUp = 0; lenUp < length; ++lenUp) {
                        startPos.move(dir, -1);
                        if (surface.test(level.getBlockState((BlockPos)startPos))) continue;
                        return true;
                    }
                    return false;
                }
                startPos.move(dir, -1);
                return true;
            }
            startPos.move(dir, 1);
        }
        return false;
    }

    public static boolean findSurroundingSurface(LevelAccessor level, BlockPos.MutableBlockPos startPos, Direction dir, int length, Predicate<BlockState> surface) {
        BlockState beforeState = null;
        for (int len = 0; len < length; ++len) {
            BlockState nowState = level.getBlockState((BlockPos)startPos);
            if (surface.test(nowState)) {
                if (len == 0) {
                    beforeState = nowState;
                    for (int lenUp = 0; lenUp < length; ++lenUp) {
                        startPos.move(dir, -1);
                        nowState = level.getBlockState((BlockPos)startPos);
                        if (BlocksHelper.isFree(nowState)) {
                            return surface.test(beforeState);
                        }
                        beforeState = nowState;
                    }
                    return false;
                }
                startPos.move(dir, -1);
                return BlocksHelper.isFree(beforeState);
            }
            beforeState = nowState;
            startPos.move(dir, 1);
        }
        return false;
    }

    public static boolean isFreeSpace(LevelAccessor level, BlockPos startPos, Direction dir, int length, Predicate<BlockState> freeSurface) {
        BlockPos.MutableBlockPos POS = startPos.mutable();
        for (int len = 0; len < length; ++len) {
            if (!freeSurface.test(level.getBlockState((BlockPos)POS))) {
                return false;
            }
            POS.move(dir, 1);
        }
        return true;
    }

    public static int blockCount(LevelAccessor level, BlockPos startPos, Direction dir, int length, Predicate<BlockState> freeSurface) {
        BlockPos.MutableBlockPos POS = startPos.mutable();
        for (int len = 0; len < length; ++len) {
            if (!freeSurface.test(level.getBlockState((BlockPos)POS))) {
                return len;
            }
            POS.move(dir, 1);
        }
        return length;
    }

    public static boolean isLava(BlockState state) {
        return state.getFluidState().getType() instanceof LavaFluid;
    }

    public static boolean isFluid(BlockState state) {
        return state.liquid();
    }

    public static boolean isFree(BlockState state) {
        return state.isAir();
    }

    public static boolean isFreeOrReplaceable(BlockState state) {
        return state.isAir() || state.canBeReplaced();
    }

    public static boolean isFreeOrFluid(BlockState state) {
        return state.isAir() || BlocksHelper.isFluid(state);
    }

    public static boolean isTerrain(BlockState state) {
        return state.is(CommonBlockTags.TERRAIN);
    }

    public static boolean isTerrainOrFluid(BlockState state) {
        return state.is(CommonBlockTags.TERRAIN) || BlocksHelper.isFluid(state);
    }

    public static Boolean replaceableOrPlant(BlockState state) {
        Block block = state.getBlock();
        if (state.is(CommonBlockTags.PLANT) || state.is(CommonBlockTags.WATER_PLANT) || block instanceof BehaviourPlantLike) {
            return true;
        }
        if (state.getPistonPushReaction() == PushReaction.DESTROY && block.defaultDestroyTime() == 0.0f) {
            return true;
        }
        if (state.getSoundType() == SoundType.GRASS || state.getSoundType() == SoundType.WET_GRASS || state.getSoundType() == SoundType.CROP || state.getSoundType() == SoundType.CAVE_VINES) {
            return true;
        }
        return state.canBeReplaced();
    }

    public static void forAllInBounds(BoundingBox bb, Consumer<BlockPos> worker) {
        for (int x = bb.minX(); x <= bb.maxX(); ++x) {
            for (int y = bb.minY(); y <= bb.maxY(); ++y) {
                for (int z = bb.minZ(); z <= bb.maxZ(); ++z) {
                    BlockPos bp = new BlockPos(x, y, z);
                    worker.accept(bp);
                }
            }
        }
    }

    public static void forOutlineInBounds(BoundingBox bb, Consumer<BlockPos> worker) {
        for (int x = bb.minX(); x <= bb.maxX(); ++x) {
            worker.accept(new BlockPos(x, bb.minY(), bb.minZ()));
            worker.accept(new BlockPos(x, bb.maxY(), bb.minZ()));
            worker.accept(new BlockPos(x, bb.minY(), bb.maxZ()));
            worker.accept(new BlockPos(x, bb.maxY(), bb.maxZ()));
        }
        for (int y = bb.minY(); y <= bb.maxY(); ++y) {
            worker.accept(new BlockPos(bb.minX(), y, bb.minZ()));
            worker.accept(new BlockPos(bb.maxX(), y, bb.minZ()));
            worker.accept(new BlockPos(bb.minX(), y, bb.maxZ()));
            worker.accept(new BlockPos(bb.maxX(), y, bb.maxZ()));
        }
        for (int z = bb.minZ(); z <= bb.maxZ(); ++z) {
            worker.accept(new BlockPos(bb.minX(), bb.minY(), z));
            worker.accept(new BlockPos(bb.maxX(), bb.minY(), z));
            worker.accept(new BlockPos(bb.minX(), bb.maxY(), z));
            worker.accept(new BlockPos(bb.maxX(), bb.maxY(), z));
        }
    }
}

