/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class ItemUtil {
    public static MapCodec<ItemStack> CODEC_ITEM_STACK_WITH_NBT = ItemUtil.codecItemStackWithNBT(Function.identity(), Function.identity());
    private static final Codec<Ingredient.ItemValue> ITEM_VALUE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CODEC_ITEM_STACK_WITH_NBT.fieldOf("item").forGetter(Ingredient.ItemValue::item)).apply((Applicative)instance, Ingredient.ItemValue::new));
    public static final Codec<Ingredient.TagValue> TAG_VALUE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(Ingredient.TagValue::tag)).apply((Applicative)instance, Ingredient.TagValue::new));
    private static final Codec<Ingredient.Value> VALUE_CODEC = Codec.xor(ITEM_VALUE_CODEC, TAG_VALUE_CODEC).xmap(either -> (Ingredient.Value)either.map(itemValue -> itemValue, tagValue -> tagValue), value -> {
        if (value instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            return Either.right((Object)tagValue);
        }
        if (value instanceof Ingredient.ItemValue) {
            Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
            return Either.left((Object)itemValue);
        }
        throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
    });
    public static Codec<Ingredient> CODEC_INGREDIENT_WITH_NBT = ItemUtil.codecIngredientWithNBT(false);
    public static Codec<Ingredient> CODEC_LENIENT_INGREDIENT_WITH_NBT = ItemUtil.codecIngredientWithNBT(true);

    private static DataComponentMap getComponents(ItemStack stack) {
        DataComponentMap components = stack.getComponents().filter(c -> {
            ItemEnchantments data;
            return c == DataComponents.ENCHANTMENTS ? (data = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)) != null && !data.isEmpty() : (c == DataComponents.ATTRIBUTE_MODIFIERS ? (data = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS)) != null && !data.modifiers().isEmpty() : c == DataComponents.STORED_ENCHANTMENTS && (data = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS)) != null && !data.isEmpty());
        });
        if (components.isEmpty()) {
            return DataComponentMap.EMPTY;
        }
        return components;
    }

    public static <T> MapCodec<T> codecItemStackWithNBT(Function<T, ItemStack> getter, Function<ItemStack, T> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").forGetter(o -> ((ItemStack)getter.apply(o)).getItemHolder()), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(o -> ((ItemStack)getter.apply(o)).getCount()), (App)DataComponentMap.CODEC.optionalFieldOf("nbt", (Object)DataComponentMap.EMPTY).forGetter(o -> ItemUtil.getComponents((ItemStack)getter.apply(o)))).apply((Applicative)instance, (item, count, nbt) -> {
            ItemStack stack = new ItemStack(item, count.intValue());
            if (nbt != null) {
                stack.applyComponents(nbt);
            }
            return factory.apply(stack);
        }));
    }

    public static Codec<Ingredient> codecIngredientWithNBT(boolean lenient) {
        Codec codec = Codec.list(VALUE_CODEC).comapFlatMap(list -> !lenient && list.isEmpty() ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)list.toArray(new Ingredient.Value[0])), List::of);
        return Codec.either((Codec)codec, VALUE_CODEC).flatComapMap(either -> (Ingredient)either.map(Ingredient::new, value -> new Ingredient(new Ingredient.Value[]{value})), ingredient -> {
            if (ingredient.values.length == 1) {
                return DataResult.success((Object)Either.right((Object)ingredient.values[0]));
            }
            return ingredient.values.length == 0 && !lenient ? DataResult.error(() -> "Item array cannot be empty, at least one item must be defined") : DataResult.success((Object)Either.left((Object)ingredient.values));
        });
    }
}

