/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.network;

import de.ambertation.wunderlib.network.ClientBoundNetworkPayload;
import de.ambertation.wunderlib.network.NetworkPayload;
import de.ambertation.wunderlib.network.PacketHandler;
import de.ambertation.wunderlib.network.SendToClientAdapter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.ApiStatus;

public class ClientBoundPacketHandler<T extends ClientBoundNetworkPayload<T>>
extends PacketHandler<T> {
    private static final List<ClientBoundPacketHandler<?>> packetHandlers = new LinkedList();
    private static PayloadRegistrar registrar;
    private static SendToClientAdapter sendToClientAdapter;

    @ApiStatus.Internal
    static void registerAdapter(SendToClientAdapter adapter) {
        sendToClientAdapter = adapter;
        for (ClientBoundPacketHandler<?> packetHandler : packetHandlers) {
            adapter.setupConnectionHandler(packetHandler);
        }
    }

    @ApiStatus.Internal
    public static void registerPayloads(PayloadRegistrar registrar) {
        ClientBoundPacketHandler.registrar = registrar;
        for (ClientBoundPacketHandler<?> packetHandler : packetHandlers) {
            ClientBoundPacketHandler.registerPayload(registrar, packetHandler);
        }
        packetHandlers.clear();
    }

    public ClientBoundPacketHandler(ResourceLocation channel, NetworkPayload.NetworkPayloadFactory<T> factory) {
        super(channel, factory);
    }

    public static <T extends ClientBoundNetworkPayload<T>> void register(ClientBoundPacketHandler<T> packetHandler) {
        if (registrar != null) {
            ClientBoundPacketHandler.registerPayload(registrar, packetHandler);
        } else {
            packetHandlers.add(packetHandler);
        }
        if (sendToClientAdapter != null) {
            sendToClientAdapter.setupConnectionHandler(packetHandler);
        }
    }

    public static <T extends ClientBoundNetworkPayload<T>> ClientBoundPacketHandler<T> register(ResourceLocation channel, NetworkPayload.NetworkPayloadFactory<T> factory) {
        ClientBoundPacketHandler<T> packetHandler = new ClientBoundPacketHandler<T>(channel, factory);
        ClientBoundPacketHandler.register(packetHandler);
        return packetHandler;
    }

    public static <T extends ClientBoundNetworkPayload<T>> void sendToClient(ServerPlayer player, T payload) {
        payload.prepareOnServer(player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends ClientBoundNetworkPayload<T>> void sendToClient(ServerLevel serverLevel, T payload) {
        ClientBoundPacketHandler.sendToClient(serverLevel.players(), payload);
    }

    public static <T extends ClientBoundNetworkPayload<T>> void sendToClient(Collection<ServerPlayer> players, T payload) {
        players.forEach(player -> {
            payload.prepareOnServer((ServerPlayer)player);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    private static <T extends ClientBoundNetworkPayload<T>> void registerPayload(PayloadRegistrar registrar, ClientBoundPacketHandler<T> packetHandler) {
        registrar.playToClient(packetHandler.CHANNEL, packetHandler.STREAM_CODEC, packetHandler::receiveOnClient);
    }

    private void receiveOnClient(T payload, IPayloadContext context) {
        ((ClientBoundNetworkPayload)payload).processOnClient(reply -> PacketDistributor.sendToServer((CustomPacketPayload)reply, (CustomPacketPayload[])new CustomPacketPayload[0]));
        CompletableFuture future = context.enqueueWork(() -> {
            Minecraft client = Minecraft.getInstance();
            if (client != null) {
                payload.processOnGameThread(client);
            }
        });
        if (((NetworkPayload)payload).isBlocking()) {
            future.join();
        }
    }
}

